import * as React from 'react';
import type { ScreenBase } from '../../service/screen-base';
import type { ContextType } from '../../types';
import type { EditableFieldProperties } from '../editable-field-control-object';
import type { NestedFieldHandlersArguments } from '../nested-fields';
import { ReadonlyFieldBaseComponent } from './field-base-component';
import type { Postfixable, Prefixable } from './traits';
export interface CarbonWrapperProps {
    children: React.ReactNode;
    className: string;
    componentName: string;
    componentRef?: React.RefObject<any>;
    contextType?: ContextType;
    handlersArguments?: NestedFieldHandlersArguments;
    helperText?: string;
    isReadOnly?: ((value: any, rowValue?: any) => boolean) | boolean;
    map?: (value?: any) => string;
    nestedReadOnlyField?: boolean;
    shouldRenderLabelInNestedReadOnlyMode?: boolean;
    noReadOnlySupport?: boolean;
    isNested?: boolean;
    readOnlyDisplayValue?: string;
    readOnlyTooltip?: string;
    isTitleHidden?: boolean;
}
export declare class CarbonWrapper extends ReadonlyFieldBaseComponent<EditableFieldProperties & Prefixable<ScreenBase> & Postfixable<ScreenBase>, any, CarbonWrapperProps> {
    getMappedValue: () => string;
    getDisplayValue(): string;
    onClick: () => Promise<void>;
    getReadonlyValueNode: (rowValue: any) => React.ReactElement;
    render(): React.ReactNode;
}
//# sourceMappingURL=carbon-wrapper.d.ts.map