import React from 'react';
import Icon from 'carbon-react/esm/components/icon';
import * as tokens from '@sage/design-tokens/js/base/common';
export function FieldLabel({ label, children, htmlFor, className = '', errorMessage, infoMessage, warningMessage, id, }) {
    return (React.createElement("label", { id: id, "data-element": "label", className: `common-input__label ${className}`.trim(), "data-testid": "e-field-label", htmlFor: htmlFor },
        label,
        children,
        errorMessage && (React.createElement(Icon, { mr: 8, type: "error", tooltipMessage: errorMessage, ariaLabel: errorMessage, color: tokens.colorsSemanticNegative500 })),
        !errorMessage && !warningMessage && infoMessage && (React.createElement(Icon, { key: "info", className: "e-icon-validation-errors", ariaLabel: infoMessage, fontSize: "small", color: tokens.colorsSemanticInfo500, type: "info", role: "tooltip", tooltipMessage: infoMessage })),
        !errorMessage && warningMessage && (React.createElement(Icon, { key: "warning", className: "e-icon-validation-errors", ariaLabel: warningMessage, fontSize: "small", color: tokens.colorsSemanticCaution500, type: "warning", role: "tooltip", tooltipMessage: warningMessage }))));
}
export function HelperText({ helperText }) {
    return (React.createElement("span", { "data-element": "help", className: "common-input__help-text", "data-testid": "e-field-helper-text" }, helperText || ' '));
}
export const getFieldElement = (className, element) => {
    if (element) {
        return React.createElement("span", { className: className }, element);
    }
    return undefined;
};
//# sourceMappingURL=carbon-utility-components.js.map