import type { ValidationResult } from '../../service/screen-base-definition';
import { ContextType } from '../../types';
import type { ValueOrCallbackWithFieldValue } from '../../utils/types';
import type { UiComponentProperties } from '../abstract-ui-control-object';
import type { PageProperties } from '../container/container-properties';
import type { EditableFieldProperties } from '../editable-field-control-object';
import type { NestedFieldHandlersArguments } from '../nested-fields';
import type { ReadonlyFieldProperties } from '../readonly-field-control-object';
import type { EditableFieldComponentProperties, FieldComponentExternalProperties, NestedFieldsAdditionalProperties } from './field-base-component-types';
export type FieldProps = EditableFieldComponentProperties<any, any> & FieldComponentExternalProperties & NestedFieldsAdditionalProperties;
export declare const getLabelTitle: (screenId: string, fieldProperties: Pick<EditableFieldProperties, "isTitleHidden" | "isMandatory" | "title">, rowValue: any) => string | undefined;
export declare const generateFieldId: ({ contextType, elementId, fieldProperties, isNested, parentElementId, screenId, }: {
    contextType?: ContextType;
    elementId: string;
    fieldProperties: any;
    isNested: boolean;
    parentElementId?: string;
    screenId: string;
}) => string;
export declare const isFieldReadOnly: (screenId: string, fieldProperties: Pick<EditableFieldProperties, "isReadOnly">, fieldValue: any, rowValue: any, contextType?: ContextType) => boolean;
interface GetFieldIndicatorStatusArgs {
    screenId: string;
    value?: any;
    validationErrors?: ValidationResult[];
    fieldProperties: {
        warningMessage?: ValueOrCallbackWithFieldValue<any, string>;
        infoMessage?: ValueOrCallbackWithFieldValue<any, string>;
    };
    handlersArguments?: NestedFieldHandlersArguments;
    isParentDisabled?: boolean;
    isParentHidden?: boolean;
}
export declare const getFieldIndicatorStatus: ({ validationErrors, screenId, value: fieldValue, fieldProperties, handlersArguments, isParentDisabled, isParentHidden, }: GetFieldIndicatorStatusArgs) => {
    error?: string;
    info?: string;
    warning?: string;
};
export declare const isFieldDisabled: (screenId: string, fieldProperties: Pick<EditableFieldProperties, "isDisabled">, fieldValue: any, rowValue: any) => boolean;
export declare const getFieldTitle: (screenId: string, fieldProperties: Pick<UiComponentProperties, "title">, rowValue: any) => string;
export declare const isFieldHidden: (screenId: string, fieldProperties: Pick<UiComponentProperties, "isHidden">, rowValue: any) => boolean;
export declare const isFieldTitleHidden: (screenId: string, fieldProperties: Pick<UiComponentProperties, "isTitleHidden">, rowValue: any) => boolean;
export declare const getFieldHelperText: (screenId: string, fieldProperties: Pick<ReadonlyFieldProperties, "helperText">, rowValue: any) => string;
export declare const isFieldHelperTextHidden: (screenId: string, fieldProperties: Pick<ReadonlyFieldProperties, "isHelperTextHidden">, rowValue: any) => string;
export declare const getPageSubtitle: (screenId: string, fieldProperties: Pick<PageProperties, "subtitle">, rowValue: any) => string | null;
export declare const onBlurHandler: (props: FieldProps) => void;
export declare const onFocusHandler: (props: FieldProps) => void;
export declare const getCommonCarbonComponentProperties: (props: FieldProps, children?: JSX.Element) => any;
export {};
//# sourceMappingURL=carbon-helpers.d.ts.map