/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { CalendarControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class CalendarDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = CalendarControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Calendar]{@link CalendarControlObject} field with the provided properties
 *
 * @param properties The properties that the [Calendar]{@link CalendarControlObject} field will be initialized with
 */
export function calendarField(properties) {
    return standardDecoratorImplementation(properties, CalendarDecorator, FieldKey.Calendar, true);
}
export function calendarFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=calendar-decorator.js.map