import * as React from 'react';
import { ReadonlyFieldBaseComponent } from '../field-base-component';
import type { CalendarComponentAdditionalProps, CalendarComponentInternalProps, CalendarState, InternalCalendarProperties } from './calendar-types';
import type { CollectionValue } from '../../../service/collection-data-service';
import type { NodePropertyType } from '../../../types';
export declare class CalendarComponent extends ReadonlyFieldBaseComponent<InternalCalendarProperties, CollectionValue, CalendarComponentAdditionalProps & {
    fieldProperties: InternalCalendarProperties;
}, CalendarState> {
    constructor(props: CalendarComponentInternalProps);
    private readonly onFilterChange;
    private readonly saveFilters;
    private readonly onSelectView;
    private readonly getTypedEventItems;
    private readonly getEventItems;
    render(): React.ReactNode;
}
export declare const ConnectedCalendarComponent: import("react-redux").ConnectedComponent<typeof CalendarComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<CalendarComponent> | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    contextNode?: NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedCalendarComponent;
//# sourceMappingURL=calendar-component.d.ts.map