import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedCalendarComponent = React.lazy(() => import('./calendar-component'));
export function AsyncConnectedCalendarComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedCalendarComponent, { ...props })));
}
const CalendarComponent = React.lazy(() => import('./calendar-component').then(c => ({ default: c.CalendarComponent })));
export function AsyncCalendarComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(CalendarComponent, { ...props })));
}
//# sourceMappingURL=async-calendar-component.js.map