/**
 * @packageDocumentation
 * @module root
 * */
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
/**
 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
 */
export class ButtonControlObject extends ReadonlyFieldControlObject {
    /** The border color of the button */
    get borderColor() {
        return this.getResolvedProperty('borderColor', false);
    }
    /** The border color of the button */
    set borderColor(newValue) {
        this.setUiComponentProperties('borderColor', newValue);
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
}
//# sourceMappingURL=button-control-object.js.map