import Button from 'carbon-react/esm/components/button';
import * as React from 'react';
import { connect } from 'react-redux';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { mapDispatchToProps, mapReadonlyStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
export class ButtonComponent extends ReadonlyFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.onClick = () => {
            // TODO: improve "getClickHandler"
            if (this.props.onClick) {
                this.props.onClick();
                return;
            }
            this.props.onFocus();
            this.getClickHandler()();
        };
    }
    getFocusableElement(element) {
        return element.querySelector('button');
    }
    render() {
        const label = !this.props.fieldProperties.isTitleHidden && this.getTitle();
        return (React.createElement("div", { ...this.getBaseAttributesDivWrapper('button', 'e-button-field', this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested), ref: this.componentRef },
            label && React.createElement(FieldLabel, { label: label }),
            React.createElement(Button, { disabled: this.isDisabled(), onClick: this.onClick, size: this.props.fieldProperties.size, iconType: this.props.icon, buttonType: this.props.buttonType, destructive: this.props.isDestructive }, this.getValue() || '&nbsp;'),
            React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText })));
    }
}
export const ConnectedButtonComponent = connect(mapReadonlyStateToProps(), mapDispatchToProps())(ButtonComponent);
export default ConnectedButtonComponent;
//# sourceMappingURL=button-component.js.map