import type { ButtonProps } from 'carbon-react/esm/components/button';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import * as React from 'react';
import { ReadonlyFieldBaseComponent } from '../field-base-component';
import type { ButtonDecoratorProperties } from './button-types';
export declare class ButtonComponent extends ReadonlyFieldBaseComponent<ButtonDecoratorProperties, string, {
    icon?: IconType;
    buttonType?: ButtonProps['buttonType'];
    isDestructive?: boolean;
    onClick?: () => void;
}> {
    getFocusableElement(element: HTMLElement): HTMLButtonElement | null;
    onClick: () => void;
    render(): React.ReactNode;
}
export declare const ConnectedButtonComponent: import("react-redux").ConnectedComponent<typeof ButtonComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ButtonComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    onClick?: (() => void) | undefined;
    buttonType?: import("carbon-react/esm/components/button/button.component").ButtonTypes | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    icon?: IconType | undefined;
    isDestructive?: boolean | undefined;
    screenId: string;
    parentElementId?: string | undefined;
    level?: number | undefined;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedButtonComponent;
//# sourceMappingURL=button-component.d.ts.map