import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedButtonComponent = React.lazy(() => import('./button-component'));
export function AsyncConnectedButtonComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedButtonComponent, { ...props })));
}
const ButtonComponent = React.lazy(() => import('./button-component').then(c => ({ default: c.ButtonComponent })));
export function AsyncButtonComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(ButtonComponent, { ...props })));
}
//# sourceMappingURL=async-button-component.js.map