import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedAggregateComponent = React.lazy(() => import('./aggregate-component'));
export function AsyncConnectedAggregateComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedAggregateComponent, { ...props })));
}
const AggregateComponent = React.lazy(() => import('./aggregate-component').then(c => ({ default: c.AggregateComponent })));
export function AsyncAggregateComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(AggregateComponent, { ...props })));
}
//# sourceMappingURL=async-aggregate-component.js.map