import * as React from 'react';
import { connect } from 'react-redux';
import { formatNumericValue, getScalePrefixPostfixFromUnit } from '../../../utils/formatters';
import { CarbonWrapper } from '../carbon-wrapper';
import { mapDispatchToProps, mapStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
export class AggregateComponent extends ReadonlyFieldBaseComponent {
    render() {
        const computedUnitProperties = getScalePrefixPostfixFromUnit(this.props.screenId, this.props.locale, this.props.fieldProperties, this.props.handlersArguments?.rowValue);
        const value = this.props.value && Number.isNaN(Number(this.props.value))
            ? this.props.value
            : (computedUnitProperties?.scale ??
                formatNumericValue({
                    screenId: this.props.screenId,
                    value: this.props.value,
                    scale: this.props.fieldProperties.scale,
                    rowValue: this.props.handlersArguments?.rowValue,
                }));
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-aggregate-field", componentName: "aggregate", componentRef: this.componentRef, fieldProperties: {
                ...this.props.fieldProperties,
                isReadOnly: true,
            }, handlersArguments: this.props.handlersArguments, value: value },
            React.createElement("noscript", null)));
    }
}
export const ConnectedAggregateComponent = connect(mapStateToProps(), mapDispatchToProps())(AggregateComponent);
export default ConnectedAggregateComponent;
//# sourceMappingURL=aggregate-component.js.map