var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { triggerHandledEvent } from '../utils/events';
import { ControlObjectProperty } from './property-decorators/control-object-property-decorator';
import { FieldControlObjectResolvedProperty } from './property-decorators/control-object-resolved-property-decorator';
import { ReadonlyFieldControlObject } from './readonly-field-control-object';
/**
 * Any element holding a value than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting field's ui properties values). The element value CAN be modified
 */
export class EditableFieldControlObject extends ReadonlyFieldControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
        isMandatory: false,
        isReadOnly: false,
    }; }
    constructor(properties) {
        super(properties);
        this._isFieldDirty = properties.isFieldDirty;
        this._setFieldDirty = properties.setFieldDirty;
        this._setFieldClean = properties.setFieldClean;
        this._dispatchFieldValidation = (_screenId) => {
            return properties.dispatchValidation
                ? properties.dispatchValidation(_screenId, this.elementId)
                : Promise.reject();
        };
    }
    get isDirty() {
        return this._isFieldDirty(this.screenId, this.elementId);
    }
    set isDirty(newValue) {
        if (newValue) {
            this._setFieldDirty(this.screenId, this.elementId);
        }
        else {
            this._setFieldClean(this.screenId, this.elementId);
        }
    }
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result
     */
    async validate() {
        const validationResult = await this._dispatchFieldValidation(this.screenId, this.elementId);
        return validationResult === undefined || validationResult.length === 0
            ? undefined
            : validationResult.map(v => v.message).join('\n');
    }
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    async validateWithDetails() {
        return this._dispatchFieldValidation(this.screenId, this.elementId);
    }
    async executeOnChange(executeErrorHandlers = false) {
        const onChange = this.getUiComponentProperty('onChange');
        if (onChange) {
            if (executeErrorHandlers) {
                await triggerHandledEvent(this.screenId, this.elementId, {
                    onChange,
                    onError: this.getUiComponentProperty('onError') || undefined,
                });
            }
            else {
                await triggerHandledEvent(this.screenId, this.elementId, {
                    onChange,
                    delegateErrorToCaller: true,
                });
            }
        }
    }
}
__decorate([
    FieldControlObjectResolvedProperty()
], EditableFieldControlObject.prototype, "isMandatory", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
], EditableFieldControlObject.prototype, "isReadOnly", void 0);
__decorate([
    ControlObjectProperty()
], EditableFieldControlObject.prototype, "infoMessage", void 0);
__decorate([
    ControlObjectProperty()
], EditableFieldControlObject.prototype, "warningMessage", void 0);
//# sourceMappingURL=editable-field-control-object.js.map