export class TileGridManager {
    constructor(width) {
        this.state = [];
        this.width = width;
    }
    getCurrentRow() {
        return this.state[this.state.length - 1];
    }
    getRemainingColumns() {
        let result = this.width;
        this.getCurrentRow().forEach(col => {
            result -= col.columnSpan;
        });
        return result;
    }
    isEmptyState() {
        return this.state.length === 0;
    }
    wouldOverflow(item) {
        return this.getRemainingColumns() < item.columnSpan;
    }
    appendItem(item) {
        if (item.isHidden) {
            return;
        }
        if (this.isEmptyState() || this.wouldOverflow(item)) {
            this.state.push([]);
        }
        const currentRow = this.getCurrentRow();
        if (currentRow.length === 0) {
            currentRow.push({
                ...item,
                columnStart: this.width - item.columnSpan + 1,
                isFirstInRow: true,
                isLastInRow: true,
            });
            return;
        }
        currentRow[0].columnStart = (currentRow[0].columnStart || 0) - item.columnSpan;
        currentRow[currentRow.length - 1].isLastInRow = false;
        currentRow.push({
            ...item,
            isFirstInRow: false,
            isLastInRow: true,
        });
    }
    getState() {
        const state = {};
        this.state.forEach(row => {
            row.forEach(col => {
                state[col.elementId] = col;
            });
        });
        return state;
    }
}
//# sourceMappingURL=tile-grid-manager.js.map