import * as React from 'react';
import { connect } from 'react-redux';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { getFieldTitle, getFieldHelperText, isFieldHelperTextHidden, isFieldTitleHidden, } from '../../field/carbon-helpers';
import { getFieldDisplayValue } from '../../../utils/id-field-utils';
import Icon from 'carbon-react/esm/components/icon';
import { getDataTestIdAttribute } from '../../../utils/dom';
import { kebabCase } from 'lodash';
import { FieldKey } from '../../types';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { triggerFieldEvent } from '../../../utils/events';
import { getScalePrefixPostfixFromUnit } from '../../../utils/formatters';
const rightAlignedFieldTypes = [FieldKey.Aggregate, FieldKey.Numeric, FieldKey.Count];
function TileField(props) {
    const title = getFieldTitle(props.screenId, props.fieldProperties, null);
    const helperText = getFieldHelperText(props.screenId, props.fieldProperties, null);
    const isTitleHidden = isFieldTitleHidden(props.screenId, props.fieldProperties, null);
    const isHelperTextHidden = isFieldHelperTextHidden(props.screenId, props.fieldProperties, null);
    const fieldProperties = props.fieldProperties;
    const fieldType = props.fieldProperties._controlObjectType;
    const testIdType = kebabCase(String(fieldType));
    const isRightAligned = rightAlignedFieldTypes.includes(fieldType);
    const computedUnitProperties = getScalePrefixPostfixFromUnit(props.screenId, props.locale, props.fieldProperties);
    const prefix = computedUnitProperties?.prefix ??
        (resolveByValue({
            fieldValue: props.value,
            propertyValue: fieldProperties.prefix,
            rowValue: null,
            skipHexFormat: true,
            screenId: props.screenId,
        }) ||
            '');
    const postfix = computedUnitProperties?.postfix ??
        (resolveByValue({
            fieldValue: props.value,
            propertyValue: fieldProperties.postfix,
            rowValue: null,
            skipHexFormat: true,
            screenId: props.screenId,
        }) ||
            '');
    const isDisabled = props.isParentDisabled ||
        resolveByValue({
            fieldValue: props.value,
            propertyValue: fieldProperties.isDisabled,
            rowValue: null,
            skipHexFormat: true,
            screenId: props.screenId,
        });
    const onClick = async () => {
        if (!isDisabled) {
            await triggerFieldEvent(props.screenId, props.elementId, 'onClick');
        }
    };
    const fieldBody = (React.createElement(React.Fragment, null,
        React.createElement("label", { className: "e-tile-field-title", "data-element": "label", "data-testid": "e-field-label" }, !isTitleHidden && title && title.toUpperCase()),
        React.createElement("div", { className: "e-tile-field-value" },
            prefix && (React.createElement("span", { className: "e-field-value-prefix", "data-testid": "e-field-value-prefix" }, prefix)),
            React.createElement("span", { "data-testid": "e-field-value" }, getFieldDisplayValue(props.pageDefinition, props.fieldController, props.locale)),
            postfix && (React.createElement("span", { className: "e-field-value-postfix", "data-testid": "e-field-value-postfix" }, postfix)),
            fieldProperties.icon && React.createElement(Icon, { type: fieldProperties.icon, color: fieldProperties.iconColor })),
        React.createElement("span", { className: "e-tile-field-helper-text", "data-testid": "e-field-helper-text" }, !isHelperTextHidden && helperText)));
    const classes = ['e-tile-field'];
    if (isRightAligned) {
        classes.push('e-tile-field-right-aligned');
    }
    if (isDisabled) {
        classes.push('e-disabled');
    }
    return fieldProperties.onClick ? (React.createElement("button", { "data-testid": getDataTestIdAttribute(testIdType, title, props.elementId), className: classes.join(' '), onClick: onClick, type: "button", disabled: isDisabled }, fieldBody)) : (React.createElement("div", { "data-testid": getDataTestIdAttribute(testIdType, title, props.elementId), className: classes.join(' ') }, fieldBody));
}
const mapStateToProps = (state, props) => {
    if (!props.item) {
        throw new Error(`No item definition found for tile field ${props.screenId}`);
    }
    const elementId = props.item.$bind;
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const fieldProperties = pageDefinition.metadata.uiComponentProperties[elementId];
    return {
        ...props,
        browser: state.browser,
        fieldController: pageDefinition.metadata.controlObjects[elementId],
        fieldProperties,
        locale: state.applicationContext?.locale || 'en-US',
        pageDefinition,
        value: pageDefinition.values[elementId],
    };
};
export const ConnectedTileField = connect(mapStateToProps)(TileField);
//# sourceMappingURL=tile-field.js.map