/**
 * @packageDocumentation
 * @module root
 * */
import { dispatchContainerValidation } from '../../../service/dispatch-service';
import { getPageMetadata } from '../../../service/page-metadata';
import { getValidationState } from '../../../service/validation-service';
import { getTargetPrototype } from '../../../utils/decorator-utils';
import { AbstractDecorator } from '../../abstract-decorator';
import { TileControlObject } from '../../control-objects';
import { ContainerKey } from '../../types';
import { TileLayout } from '../layouts';
class TileDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._layout = TileLayout;
        this._controlObjectConstructor = TileControlObject;
    }
}
/**
 * Initializes the decorated member as a [Tile]{@link TileControlObject} container with the provided properties
 *
 * @param properties The properties that the [Tile]{@link TileControlObject} container will be initialized with
 */
export function tile(properties) {
    return function tileDecorator(target, name) {
        const pageMetadata = getPageMetadata(getTargetPrototype(target.constructor), target);
        pageMetadata.definitionOrder.push(name);
        pageMetadata.blockThunks[name] = (nodeTypes, dataTypes) => new TileDecorator(pageMetadata.target, name, { pageMetadata, properties }, ContainerKey.Tile, nodeTypes, dataTypes, {
            getValidationState: async () => getValidationState(pageMetadata.screenId, name),
            dispatchTileValidation: () => dispatchContainerValidation(target.constructor.name, name),
        }).build().layout;
    };
}
//# sourceMappingURL=tile-decorator.js.map