/**
 * @packageDocumentation
 * @module root
 * */
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { ContainerKey } from '../../types';
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export class TileControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
    }; }
    constructor(properties) {
        super(properties.screenId, properties.elementId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.Tile, properties.getValidationState || (async () => true), properties.layout, properties.parent);
        this.insertBefore = properties.insertBefore;
        this._dispatchTileValidation = properties.dispatchTileValidation;
    }
    async validateWithDetails(partition = false) {
        const errors = await this._dispatchTileValidation();
        return partition ? errors : errors.allErrors;
    }
}
//# sourceMappingURL=tile-control-object.js.map