/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import { AbstractContainer } from '../../abstract-container';
import type { ContainerComponentProps, ContainerControlObjectConstructorProps, ParentType } from '../../types';
import { ContainerKey } from '../../types';
import type { TileProperties } from './tile-types';
export interface ITileControlObject extends ContainerControlObjectConstructorProps<ContainerKey.Tile> {
    parent?: ParentType<ContainerKey.Tile>;
    dispatchTileValidation: () => Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
}
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export declare class TileControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.Tile, ContainerComponentProps<ContainerKey.Tile>> {
    insertBefore?: ContainerControlObjectConstructorProps<ContainerKey.Tile>['insertBefore'];
    private readonly _dispatchTileValidation;
    static readonly defaultUiProperties: Partial<TileProperties>;
    theParentOfThisFieldNeedsToBeABlockContainer: boolean;
    constructor(properties: ITileControlObject);
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(partition: true): Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
}
//# sourceMappingURL=tile-control-object.d.ts.map