import { dispatchContainerValidation } from '../../../service/dispatch-service';
import { getPageMetadata } from '../../../service/page-metadata';
import { getValidationState } from '../../../service/validation-service';
import { getTargetPrototype, standardExtensionDecoratorImplementation } from '../../../utils/decorator-utils';
import { AbstractDecorator } from '../../abstract-decorator';
import { SectionControlObject } from '../../control-objects';
import { ContainerKey } from '../../types';
import { SectionLayout } from '../layouts';
import { getDeclarationPackage } from '../../../service/screen-loader-service';
class SectionDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._layout = SectionLayout;
        this._controlObjectConstructor = SectionControlObject;
        this.build = () => {
            return this.buildLayout().buildControlObject().buildMetadata();
        };
    }
}
/**
 * Initializes the decorated member as a [Section]{@link SectionControlObject} container with the provided properties
 *
 * @param properties The properties that the [Section]{@link SectionControlObject} container will be initialized with
 */
export function section(properties) {
    return function sectionDecorator(target, name) {
        const extensionPackageName = getDeclarationPackage();
        const pageMetadata = getPageMetadata(getTargetPrototype(target.constructor), target);
        pageMetadata.definitionOrder.push(name);
        pageMetadata.sectionThunks[name] = (nodeTypes, dataTypes) => {
            return new SectionDecorator(pageMetadata.target, name, { pageMetadata, properties, extensionPackageName }, ContainerKey.Section, nodeTypes, dataTypes, {
                dispatchSectionValidation: () => dispatchContainerValidation(target.constructor.name, name),
                getValidationState: async () => getValidationState(target.constructor.name, name),
            }).build().layout;
        };
    };
}
export function sectionOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=section-decorator.js.map