import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { SectionDecoratorProperties, SectionOverrideDecoratorProperties } from './section-types';
/**
 * Initializes the decorated member as a [Section]{@link SectionControlObject} container with the provided properties
 *
 * @param properties The properties that the [Section]{@link SectionControlObject} container will be initialized with
 */
export declare function section<CT extends ScreenExtension<CT>>(properties: SectionDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
export declare function sectionOverride<T extends ScreenExtension<T>>(properties: SectionOverrideDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=section-decorator.d.ts.map