/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { ContainerKey } from '../../types';
/**
 * [Container]{@link AbstractContainer} that holds any number of [blocks]{@link BlockControlObject}
 */
export class SectionControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
        isExtendable: false,
        isOpen: true,
        isTitleHidden: undefined,
        mode: 'normal',
    }; }
    constructor(properties) {
        super(properties.screenId, properties.elementId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.Section, properties.getValidationState || (async () => true), properties.layout);
        this._dispatchSectionValidation = properties.dispatchSectionValidation;
        this.insertBefore = properties.insertBefore;
    }
    /**
     * Triggers the validation rules of all the fields of the section. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    async validate() {
        const result = await this.validateWithDetails();
        return result.map(r => r.message);
    }
    async validateWithDetails(partition = false) {
        const errors = await this._dispatchSectionValidation();
        return partition ? errors : errors.allErrors;
    }
}
__decorate([
    ControlObjectProperty()
    /** Whether the section is collapsed (isOpen = false) or not (isOpen = true) */
], SectionControlObject.prototype, "isOpen", void 0);
__decorate([
    ControlObjectProperty()
    /**
     * Whether the section can be extended into a separate window (extendable = true)
     * or not (extendable = false)
     */
], SectionControlObject.prototype, "isExtendable", void 0);
__decorate([
    ControlObjectProperty()
], SectionControlObject.prototype, "indicatorContent", void 0);
//# sourceMappingURL=section-control-object.js.map