import { type Dict } from '@sage/xtrem-shared';
import * as React from 'react';
import type { PageArticleItem } from '../../../service/layout-types';
import { ContextType } from '../../../types';
import type { LabelControlObject } from '../../control-objects';
import type { PageMode } from './page-types';
import type { CollectionValue } from '../../../service/collection-data-service';
import type { SectionDecoratorProperties } from '../section/section-types';
import type { QueryParameters } from '../../../utils/types';
import type { FieldControlObjectInstance, PageHeaderFieldTypes } from '../../types';
export type StepStatus = 'complete' | 'current' | 'incomplete';
export interface XtremHeaderExternalProps {
    activeSection: string | null;
    areNavigationTabsHidden: boolean;
    availableColumns: number;
    contextType?: ContextType;
    hasNavigationPanel: boolean;
    headerLineBlock: Partial<PageArticleItem> | null;
    isRecordCreationPage?: boolean;
    navigationPanelValue?: CollectionValue;
    pageBodyRef: React.RefObject<HTMLDivElement>;
    screenId: string;
    setActiveSection: (sectionId: string) => void;
    hasToggleButton?: boolean;
    isDetailPanelOpen?: boolean;
}
export interface XtremHeaderProps extends XtremHeaderExternalProps {
    has360View?: boolean;
    headerField?: FieldControlObjectInstance<PageHeaderFieldTypes>;
    headerImage: string | null;
    headerLabelField?: LabelControlObject;
    headerSection: Partial<PageArticleItem> | null;
    headerTitle: string | null;
    history: {
        path: string;
        queryParams: QueryParameters;
    }[];
    idFieldValue?: string | null;
    insightCount?: number;
    is360ViewOn: boolean;
    isHeaderImageNeeded: boolean;
    isHeaderSectionClosed: boolean;
    isMobileScreen?: boolean;
    isNavigationPanelHeaderHidden: boolean;
    isNavigationPanelOpened: boolean;
    isNewPage: boolean;
    isTitleHidden?: boolean;
    objectTypePlural?: string | null;
    objectTypeSingular?: string | null;
    openSectionInDialog: (sectionId: string) => void;
    pageMode: PageMode;
    sections: Partial<PageArticleItem>[];
    sectionsProperties: Dict<SectionDecoratorProperties>;
    sectionValidationErrors: Dict<string | null>;
    shouldDisplayBackArrow: boolean;
    shouldDisplayNavigationArrows: boolean;
    subtitle?: string;
    title: string;
}
export declare class XtremHeader extends React.Component<XtremHeaderProps> {
    private readonly activeIndicator;
    private readonly tabContainer;
    private readonly tabDictionary;
    private readonly hotkeySubscriptions;
    private readonly parentRef;
    componentDidMount(): void;
    componentDidUpdate(prevProps: XtremHeaderProps): void;
    componentWillUnmount(): void;
    private setIndicatorPosition;
    private readonly getActiveSectionIndex;
    private readonly setActiveSectionByIndex;
    private readonly setActiveSection;
    private readonly hasTabs;
    private readonly getClasses;
    private readonly getVisibleTabs;
    private readonly onRecordClose;
    private readonly isDialogContext;
    private readonly hasHeaderSection;
    private readonly filterByHeaderSection;
    private readonly renderTabs;
    renderCloseIcon: () => React.ReactNode;
    private readonly renderTitleImage;
    render(): React.ReactNode;
}
export declare const ConnectedXtremHeader: import("react-redux").ConnectedComponent<typeof XtremHeader, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<XtremHeader> | undefined;
    activeSection: string | null;
    areNavigationTabsHidden: boolean;
    availableColumns: number;
    contextType?: ContextType | undefined;
    hasNavigationPanel: boolean;
    headerLineBlock: Partial<PageArticleItem> | null;
    isRecordCreationPage?: boolean | undefined;
    navigationPanelValue?: CollectionValue | undefined;
    pageBodyRef: React.RefObject<HTMLDivElement>;
    screenId: string;
    setActiveSection: (sectionId: string) => void;
    hasToggleButton?: boolean | undefined;
    isDetailPanelOpen?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=xtrem-header.d.ts.map