import * as React from 'react';
import { StepSequence, StepSequenceItem } from 'carbon-react/esm/components/step-sequence';
import { resolveByValue } from '../../../utils/resolve-value-utils';
const getWizardStepStatus = (index, currentSectionIndex) => {
    if (index === currentSectionIndex) {
        return 'current';
    }
    return index < currentSectionIndex ? 'complete' : 'incomplete';
};
export function WizardSteps({ sections, selectedSection, screenId }) {
    const currentSectionIndex = sections.findIndex(s => s.id === selectedSection);
    const steps = sections.map((section, index) => ({
        key: section.id,
        id: section.id,
        indicator: String(index + 1),
        status: getWizardStepStatus(index, currentSectionIndex),
        children: resolveByValue({
            propertyValue: section.title,
            screenId,
            fieldValue: null,
            rowValue: null,
            skipHexFormat: true,
        }),
    }));
    return (React.createElement("div", { className: "e-header-wizard-steps", "data-testid": "e-dialog-header-wizard-steps" },
        React.createElement(StepSequence, { orientation: "horizontal" }, steps.map(s => (React.createElement(StepSequenceItem, { key: s.key, ...s }))))));
}
//# sourceMappingURL=wizard-steps.js.map