import * as React from 'react';
import { useSelector } from 'react-redux';
import * as dialogService from '../../../service/dialog-service';
import { QUERY_PARAM_PRINTING_NODE_TYPE, QUERY_PARAM_PRINTING_RECORD_ID, QUERY_PARAM_PRINTING_SOURCE_PAGE, QUERY_PARAM_PRINTING_SOURCE_TYPE, } from '../../../utils/constants';
import Button from 'carbon-react/esm/components/button';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import { localize } from '../../../service/i18n-service';
import Icon from 'carbon-react/esm/components/icon';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
import { getPagePropertiesFromState } from '../../../utils/state-utils';
export function PrintRecordButton({ screenId }) {
    const printingSettings = useDeepEqualSelector(state => state.printingSettings);
    const selectedRecordId = useSelector(state => state.screenDefinitions[screenId]?.selectedRecordId || null);
    const pageNode = useDeepEqualSelector(state => getPagePropertiesFromState(screenId, state)?.node?.toString() || null);
    const onTelemetryEvent = useSelector(state => state.applicationContext?.onTelemetryEvent || null);
    const openAssignmentDialog = React.useCallback(() => {
        if (!printingSettings?.printingAssignmentDialogUrl) {
            throw new Error('printingAssignmentDialogUrl is not defined');
        }
        onTelemetryEvent?.('printRecordAssignmentDialogOpened', { screenId });
        dialogService.openPageDialog(printingSettings?.printingAssignmentDialogUrl, {
            [QUERY_PARAM_PRINTING_SOURCE_PAGE]: screenId,
            [QUERY_PARAM_PRINTING_SOURCE_TYPE]: 'record',
            [QUERY_PARAM_PRINTING_NODE_TYPE]: pageNode || '',
        }, { resolveOnCancel: true, size: 'large' });
    }, [onTelemetryEvent, pageNode, printingSettings?.printingAssignmentDialogUrl, screenId]);
    const openPrintDialog = React.useCallback(() => {
        if (!printingSettings?.recordPrintingWizardUrl) {
            throw new Error('recordPrintingWizardUrl is not defined');
        }
        if (!selectedRecordId) {
            throw new Error('No record is selected');
        }
        onTelemetryEvent?.('printRecordWizardOpened', { screenId });
        dialogService.openPageDialog(printingSettings?.recordPrintingWizardUrl, {
            [QUERY_PARAM_PRINTING_SOURCE_PAGE]: screenId,
            [QUERY_PARAM_PRINTING_NODE_TYPE]: pageNode || '',
            [QUERY_PARAM_PRINTING_RECORD_ID]: selectedRecordId,
        }, { resolveOnCancel: true, size: 'medium' });
    }, [onTelemetryEvent, pageNode, printingSettings?.recordPrintingWizardUrl, screenId, selectedRecordId]);
    if (!selectedRecordId ||
        !printingSettings ||
        (!printingSettings.canAccessPrintingAssignmentDialog && !printingSettings.canAccessRecordPrintingWizard)) {
        return null;
    }
    return (React.createElement(MultiActionButton, { buttonType: "tertiary", "aria-label": localize('@sage/xtrem-ui/table-print', 'Print'), text: (React.createElement(Icon, { type: "print", color: "var(--colorsActionMinor500)" })), "data-testid": "e-print-record-button", mr: "16px", mt: "-4px", size: "small", className: "e-print-record-button" },
        React.createElement(Button, { className: "e-print-record-dropdown-button", "data-testid": "e-print-record-assignment-button", "data-pendoid": "print-record-assignment-button", disabled: !printingSettings.canAccessPrintingAssignmentDialog, key: "assignment", onClick: openAssignmentDialog }, localize('@sage/xtrem-ui/list-printing-assignment', 'Assign report')),
        React.createElement(Button, { className: "e-print-record-dropdown-button", "data-testid": "e-print-record-wizard-button", "data-pendoid": "print-record-wizard-button", disabled: !printingSettings.canAccessRecordPrintingWizard, key: "print", onClick: openPrintDialog }, localize('@sage/xtrem-ui/list-printing', 'Select report'))));
}
//# sourceMappingURL=print-record-button.js.map