import { set } from 'lodash';
import { getPageMetadata } from '../../../service/page-metadata';
import { getTargetPrototype } from '../../../utils/decorator-utils';
import { injectOnloadAfterIntoPageMetadata } from '../../../utils/page-utils';
import { insertExtendedActions, mergeTableActions } from '../../abstract-decorator-utils';
const processNavigationPanelExtension = (pageMetadata, navigationPanel) => {
    const pageDefaultProperties = pageMetadata.defaultUiComponentProperties[pageMetadata.screenId];
    const pageProperties = pageMetadata.uiComponentProperties[pageMetadata.screenId];
    const navigationPanelDefaultProperties = pageDefaultProperties.navigationPanel;
    const navigationPanelProperties = pageProperties.navigationPanel;
    if (navigationPanel.listItem) {
        navigationPanelDefaultProperties.extensionListItem.push(navigationPanel.listItem);
        navigationPanelProperties.extensionListItem.push(navigationPanel.listItem);
    }
    if (navigationPanel.onEmptyStateLinkClick) {
        navigationPanelDefaultProperties.onEmptyStateLinkClick = navigationPanel.onEmptyStateLinkClick;
        navigationPanelProperties.onEmptyStateLinkClick = navigationPanel.onEmptyStateLinkClick;
    }
    if (navigationPanel.onEmptyStateLinkClickAfter) {
        navigationPanelDefaultProperties.onEmptyStateLinkClickAfter.push(navigationPanel.onEmptyStateLinkClickAfter);
        navigationPanelProperties.onEmptyStateLinkClickAfter.push(navigationPanel.onEmptyStateLinkClickAfter);
    }
    if (navigationPanel.onSelect) {
        navigationPanelDefaultProperties.onSelect = navigationPanel.onSelect;
        navigationPanelProperties.onSelect = navigationPanel.onSelect;
    }
    if (navigationPanel.onSelectAfter) {
        navigationPanelDefaultProperties.onSelectAfter.push(navigationPanel.onSelectAfter);
        navigationPanelProperties.onSelectAfter.push(navigationPanel.onSelectAfter);
    }
    if (navigationPanel.onOptionsMenuValueChange) {
        navigationPanelDefaultProperties.onOptionsMenuValueChange = navigationPanel.onOptionsMenuValueChange;
        navigationPanelProperties.onOptionsMenuValueChange = navigationPanel.onOptionsMenuValueChange;
    }
    if (navigationPanel.onOptionsMenuValueChangeAfter) {
        navigationPanelDefaultProperties.onOptionsMenuValueChangeAfter.push(navigationPanel.onOptionsMenuValueChangeAfter);
        navigationPanelProperties.onOptionsMenuValueChangeAfter.push(navigationPanel.onOptionsMenuValueChangeAfter);
    }
    if (navigationPanel.onEmptyStateLinkClick) {
        navigationPanelProperties.onEmptyStateLinkClick = navigationPanel.onEmptyStateLinkClick;
    }
    if (navigationPanel.optionsMenu) {
        navigationPanelProperties.optionMenus.push(navigationPanel.optionsMenu);
    }
    if (navigationPanel.emptyStateText) {
        navigationPanelProperties.emptyStateText = navigationPanel.emptyStateText;
    }
    if (navigationPanel.emptyStateClickableText) {
        navigationPanelProperties.emptyStateClickableText = navigationPanel.emptyStateClickableText;
    }
    if (navigationPanel.dropdownActions) {
        navigationPanelProperties.dropdownActions = mergeTableActions(navigationPanelProperties.dropdownActions || [], navigationPanel.dropdownActions);
    }
    if (navigationPanel.inlineActions) {
        navigationPanelProperties.inlineActions = mergeTableActions(navigationPanelProperties.inlineActions || [], navigationPanel.inlineActions);
    }
};
export function pageExtension(properties) {
    return (ctor) => {
        const targetPrototype = getTargetPrototype(ctor);
        ctor.basePage = targetPrototype.name;
        Object.getOwnPropertyNames(ctor.prototype)
            .filter(k => k !== 'constructor')
            .forEach(memberName => {
            targetPrototype.prototype[memberName] = ctor.prototype[memberName];
        });
        const pageMetadata = getPageMetadata(targetPrototype);
        pageMetadata.pageExtensionThunks.push(() => {
            const pageProperties = pageMetadata.uiComponentProperties[pageMetadata.screenId];
            if (properties.onLoad) {
                injectOnloadAfterIntoPageMetadata(pageMetadata, properties.onLoad);
            }
            if (properties.businessActions) {
                pageMetadata.businessActionsExtensionsThunk.push(properties.businessActions);
            }
            if (properties.onClose) {
                if (pageMetadata.uiComponentProperties?.[pageMetadata.screenId]?.onCloseAfter) {
                    pageMetadata.uiComponentProperties[pageMetadata.screenId].onCloseAfter.push(properties.onClose);
                    pageMetadata.defaultUiComponentProperties[pageMetadata.screenId].onCloseAfter.push(properties.onClose);
                }
                else {
                    set(pageMetadata, ['uiComponentProperties', pageMetadata.screenId, 'onCloseAfter'], [properties.onClose]);
                    set(pageMetadata, ['defaultUiComponentProperties', pageMetadata.screenId, 'onCloseAfter'], [properties.onClose]);
                }
            }
            const pageDefaultProperties = pageMetadata.defaultUiComponentProperties[pageMetadata.screenId];
            if (properties.navigationPanel) {
                if (!pageDefaultProperties.navigationPanel) {
                    throw new Error(`Cannot extend navigation panel on ${pageMetadata.screenId} because the base page does not have a navigation panel.`);
                }
                processNavigationPanelExtension(pageMetadata, properties.navigationPanel);
            }
            // Handle header dropdown actions extension
            if (properties.headerDropDownActions) {
                const baseActionsThunk = pageProperties.headerDropDownActions;
                const headerDropDownActionsOverride = function headerDropDownActionsOverride() {
                    const extendedActions = properties.headerDropDownActions?.call(this);
                    const baseActions = baseActionsThunk?.call(this) || [];
                    return insertExtendedActions(this, baseActions, extendedActions);
                };
                pageProperties.headerDropDownActions = headerDropDownActionsOverride;
                pageDefaultProperties.headerDropDownActions = headerDropDownActionsOverride;
            }
            if (properties.headerQuickActions) {
                const baseActionsThunk = pageProperties.headerQuickActions;
                const headerQuickActionsOverride = function headerQuickActionsOverride() {
                    const extendedActions = properties.headerQuickActions?.call(this);
                    const baseActions = baseActionsThunk?.call(this) || [];
                    return insertExtendedActions(this, baseActions, extendedActions);
                };
                pageProperties.headerQuickActions = headerQuickActionsOverride;
                pageDefaultProperties.headerQuickActions = headerQuickActionsOverride;
            }
        });
    };
}
//# sourceMappingURL=page-extension-decorator.js.map