/**
 * @packageDocumentation
 * @module root
 **/
import type { ClientNode } from '@sage/xtrem-client';
import { type RootMenuItem, type SubMenuItem } from '@sage/xtrem-shared';
import type { Page } from '../../../service/page';
import type { Constructible, PageExtension } from '../../../types';
import type { ValueOrCallback } from '../../../utils/types';
import { AbstractDecorator } from '../../abstract-decorator';
import type { LabelControlObject } from '../../control-objects';
import { PageControlObject } from '../../control-objects';
import type { VoidPromise } from '../../field/traits';
import type { FieldControlObjectInstance, PageCategory, PageHeaderFieldTypes } from '../../types';
import { ContainerKey } from '../../types';
import { PageLayout } from '../layouts';
import type { IdFieldType, PageProperties } from './page-types';
export interface PageDecoratorProperties<CT extends PageExtension<CT>, NodeType extends ClientNode = any> extends PageProperties<CT, NodeType> {
    /** Function code corresponding to the page */
    authorizationCode?: string;
    /**
     * Metadata field for organizing pages. It should only be used for ADC, in Xtrem, the the `menuItem` should be used
     * instead.
     * */
    category?: PageCategory;
    /** Menu item that the page belongs to on the navigation menu */
    menuItem?: SubMenuItem | RootMenuItem;
    /** Priority that determines the order of the elements in its category on the navigation panel. */
    priority?: number;
    /**
     *  Module the page belongs to
     * @deprecated it used to be used in X3, no longer relevant
     * */
    module?: string;
    /** Function that will be executed immediately after the page has been loaded */
    onLoad?: (this: CT) => VoidPromise;
    /** Function that will be executed immediately before the page closes */
    onClose?: (this: CT, isWizardFinished?: boolean) => VoidPromise;
    /** Callback which is triggered when the dirty status of the page changes */
    onDirtyStateUpdated?: (this: CT, isDirty: boolean) => void;
    /** Subtitle displayed along with the page's title */
    subtitle?: string;
    /** If set, the confirmation dialog is not displayed when the user navigates away from the page */
    skipDirtyCheck?: boolean;
    /**
     * Singular name of the object that the page represents. It is displayed above the page title like the `subtitle`.
     * If both `objectTypeSingular` and `subtitle` is defined, then `objectTypeSingular` takes precedence over `the `subtitle` on the full width navigation panel.
     */
    objectTypeSingular?: string;
    /**
     * Plural name of the object that the page represents. It is used in the navigation panel and in error messages.
     * If both `objectTypePlural` and `title` is defined, then `objectTypePlural` takes precedence over `title` on the full width navigation panel.
     * */
    objectTypePlural?: string;
    /** Callback function that can return a field instance or a string. If a non-falsy value or field instance is returned, its value is displayed in place of the title */
    idField?: (this: CT) => IdFieldType<CT>;
    /** Callback function that can return a label field from the class body. The label field is placed next to the page or record title. */
    headerLabel?: (this: CT) => LabelControlObject<any, CT>;
    /**
     * Enables a object specific dashboard option on the page.
     */
    has360View?: ValueOrCallback<CT, boolean>;
    /** Function that will be executed when the user switches between page mode and 360 view mode */
    on360ViewSwitched?: (this: CT, is360ViewOn: boolean) => void;
    /** Adds an additional section to the end of the page to manage attachments. It only works with non-transient pages that are bound to nodes with `hasAttachments` set to `true` */
    hasAttachmentsSection?: boolean;
    /** Optional non-block text-based field to show in page header */
    headerField?: (this: CT) => FieldControlObjectInstance<PageHeaderFieldTypes>;
}
export declare class PageDecorator extends AbstractDecorator<ContainerKey.Page> {
    protected _layout: typeof PageLayout;
    protected _controlObjectConstructor: typeof PageControlObject;
    protected readonly buildActions: () => this;
    protected setUiComponentProperties: () => this;
    private readonly getNavigationPanelProps;
}
/**
 * Initializes the decorated member as a [Page]{@link PageControlObject} container with the provided properties
 *
 * @param properties The properties that the [Page]{@link PageControlObject} container will be initialized with
 */
export declare function page<CT extends PageExtension<CT>, NodeType extends ClientNode = any>(properties: PageDecoratorProperties<CT, NodeType>): (ctor: Constructible<Page>) => void;
//# sourceMappingURL=page-decorator.d.ts.map