/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { getStore } from '../../../redux';
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { AbstractContainer } from '../../abstract-container';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { ContainerKey } from '../../types';
/**
 * Main [container]{@link AbstractContainer} of each screen. Holds any number of [sections]{@link SectionControlObject}
 * and might define additional parts (e.g. crud actions, business actions, a helper panel, etc.)
 */
export class PageControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
        areNavigationTabsHidden: false,
        mode: 'default',
    }; }
    constructor(properties) {
        super(properties.screenId, properties.screenId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.Page, properties.getValidationState ||
            (async () => {
                const validationErrors = await this.validateWithDetails();
                return validationErrors.length === 0;
            }), properties.layout);
        this._dispatchPageValidation = properties.dispatchPageValidation;
        this._getFocussedField = properties.getFocussedField;
    }
    /** Visualization mode */
    get mode() {
        return this.getUiComponentProperty('mode');
    }
    /** Panel where to search, filter and navigate through current page related items */
    get navigationPanel() {
        return this.getUiComponentProperty('navigationPanel');
    }
    /**
     * The GraphQL node that the page is bind to. This settings will be omitted
     * if the page is set to be transient
     */
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    get focussedField() {
        return this._getFocussedField(this.screenId);
    }
    // TODO Move this method to the abstract container
    /**
     * Triggers the validation rules of all the fields of the page. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    async validate() {
        const result = await this.validateWithDetails();
        return result.map(r => r.message);
    }
    async validateWithDetails(partition = false) {
        const errors = await this._dispatchPageValidation();
        return partition ? errors : errors.allErrors;
    }
}
__decorate([
    ControlObjectProperty()
    /** Subtitle displayed along with the page's title */
], PageControlObject.prototype, "subtitle", void 0);
// TODO: TS 4.0 had to move the accessors outside of the class - there may be a better solution
Object.defineProperty(PageControlObject.prototype, 'title', {
    get() {
        return (resolveByValue({
            propertyValue: this.getUiComponentProperty('title'),
            screenId: this.screenId,
            skipHexFormat: true,
            rowValue: null,
        }) || '');
    },
    set(newTitle) {
        this.setUiComponentProperties('title', newTitle);
        const state = getStore().getState();
        if (state.applicationContext?.onPageTitleChange) {
            const subtitle = resolveByValue({
                propertyValue: this.getUiComponentProperty('subtitle'),
                screenId: this.screenId,
                skipHexFormat: true,
                rowValue: null,
            });
            state.applicationContext?.onPageTitleChange(newTitle, subtitle || null);
        }
    },
});
Object.defineProperty(PageControlObject.prototype, 'subtitle', {
    get() {
        return (resolveByValue({
            propertyValue: this.getUiComponentProperty('subtitle'),
            screenId: this.screenId,
            skipHexFormat: true,
            rowValue: null,
        }) || '');
    },
    set(newSubtitle) {
        this.setUiComponentProperties('subtitle', newSubtitle);
        const state = getStore().getState();
        if (state.applicationContext?.onPageTitleChange) {
            const title = resolveByValue({
                propertyValue: this.getUiComponentProperty('title'),
                screenId: this.screenId,
                skipHexFormat: true,
                rowValue: null,
            });
            state.applicationContext?.onPageTitleChange(title || null, newSubtitle);
        }
    },
});
//# sourceMappingURL=page-control-object.js.map