import * as React from 'react';
import type { PageDefinition } from '../../../service/page-definition';
import { ContextType } from '../../../types';
import type { PageComponentProps } from './page-types';
interface PageComponentState {
    dialogSectionHeight?: number;
    pageBodyHeight?: number;
}
declare class PageComponent extends React.Component<PageComponentProps, PageComponentState> {
    private readonly pageBodyRef;
    private shortcutSubscriptions;
    private readonly parentRef;
    constructor(props: PageComponentProps);
    handleDialogSectionHeight: import("lodash").DebouncedFunc<() => void>;
    componentDidMount(): void;
    componentDidCatch(error: Error): void;
    componentWillUnmount(): void;
    getActiveSectionId: () => string | undefined;
    getVisibleSections: () => HTMLDivElement[];
    getActiveSectionIndex(): number;
    onBodyScroll: () => void;
    onFileDrop: (files: FileList) => Promise<void>;
    getPageClassName(): string;
    getPendoPageMode(): string;
    handle360ViewInUrl: () => void;
    hasPageFooter: () => boolean;
    hasChangedPageBodyHeight: () => boolean;
    isDialogContext(): boolean;
    isFullScreenDialogContext(): boolean;
    renderDetailPanel(): React.ReactNode;
    renderSections(availableColumns: number): React.ReactNode;
    hasToggleButton: () => boolean;
    render(): React.ReactNode;
}
declare const _default: import("react-redux").ConnectedComponent<typeof PageComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<PageComponent> | undefined;
    availableColumns: number;
    contextType: ContextType;
    isMainListDisplayedInDialog?: boolean | undefined;
    isMobileOrTabletScreen?: boolean | undefined;
    isPageDisplayedInFullScreenDialog?: boolean | undefined;
    noHeader?: boolean | undefined;
    pageDefinition: PageDefinition;
    selectedSection?: string | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=page-component.d.ts.map