import { localize } from '../../../service/i18n-service';
import * as xtremRedux from '../../../redux';
import * as React from 'react';
import { useSelector, useDispatch } from 'react-redux';
import IconButton from 'carbon-react/esm/components/icon-button';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { getHeaderSection } from '../../../utils/layout-utils';
import Icon from 'carbon-react/esm/components/icon';
import * as tokens from '@sage/design-tokens/js/base/common';
export function HeaderSectionToggleButton({ screenId }) {
    const dispatch = useDispatch();
    const hasHeaderSection = useSelector(state => {
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        return !!getHeaderSection(pageDefinition, false);
    });
    const isHeaderSectionClosed = useSelector(state => {
        return getPageDefinitionFromState(screenId, state).isHeaderSectionClosed ?? false;
    });
    const is360ViewOn = useSelector(state => {
        return getPageDefinitionFromState(screenId, state).is360ViewOn ?? false;
    });
    const onHeaderSectionToggle = React.useCallback(() => {
        dispatch(xtremRedux.actions.setPageHeaderSectionClosed({ screenId, isClosed: !isHeaderSectionClosed }));
    }, [dispatch, screenId, isHeaderSectionClosed]);
    if (!hasHeaderSection || is360ViewOn) {
        return null;
    }
    const label = isHeaderSectionClosed
        ? localize('@sage/xtrem-ui/open-header-section', 'Open header')
        : localize('@sage/xtrem-ui/close-header-section', 'Close header');
    return (React.createElement("div", { className: "e-header-toggle-icon-col" },
        React.createElement(IconButton, { "aria-label": label, "data-testid": "e-toggle-header-section", onClick: onHeaderSectionToggle, mr: "24px", "data-pendoid": isHeaderSectionClosed ? 'headerOpen' : 'headerClose' },
            React.createElement(Icon, { type: isHeaderSectionClosed ? 'chevron_up' : 'chevron_down', color: tokens.colorsUtilityMajor400, tooltipMessage: label }))));
}
//# sourceMappingURL=header-section-toggle-button.js.map