import * as React from 'react';
import type { IconType } from 'carbon-react/esm/components/icon';
import type { PageActionControlObject } from '../../page-action/page-action-control-object';
import type { OnTelemetryEventFunction } from '../../../redux/state';
export interface HeaderQuickActionExternalProp {
    screenId: string;
    id: string;
}
export interface HeaderQuickActionProp extends HeaderQuickActionExternalProp {
    icon: IconType;
    isDisabled?: boolean;
    isHidden?: boolean;
    title?: string;
    onTelemetryEvent?: OnTelemetryEventFunction;
}
export interface HeaderQuickActionsExternalProps {
    screenId: string;
    actions?: Array<PageActionControlObject>;
}
export interface HeaderQuickActionsProps extends HeaderQuickActionsExternalProps {
    headerQuickActions?: Array<PageActionControlObject>;
}
export declare function HeaderQuickActions({ screenId, headerQuickActions, }: HeaderQuickActionsProps): React.ReactElement | null;
export declare const ConnectedHeaderQuickActions: import("react-redux").ConnectedComponent<typeof HeaderQuickActions, {
    screenId: string;
    actions?: Array<PageActionControlObject> | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=header-quick-actions.d.ts.map