import * as React from 'react';
import { getRouter } from '../../../service/router';
import { connect } from 'react-redux';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import NavigationArrows from '../../ui/navigation-arrows/navigation-arrows';
export function HeaderNavigationArrows({ selectedRecordId, screenId, }) {
    const router = getRouter(screenId);
    const [hasNextRecord, setHasNextRecord] = React.useState(false);
    const [hasPreviousRecord, setPreviousRecord] = React.useState(false);
    React.useEffect(() => {
        router.hasNextRecord().then(setHasNextRecord);
    }, [selectedRecordId, router]);
    React.useEffect(() => {
        router.hasPreviousRecord().then(setPreviousRecord);
    }, [selectedRecordId, router]);
    return (React.createElement(NavigationArrows, { hasNextRecord: hasNextRecord, hasPreviousRecord: hasPreviousRecord, onNextRecord: () => router.nextRecord(), onPreviousRecord: () => router.previousRecord() }));
}
const mapStateToProps = (state, props) => {
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    return {
        ...props,
        selectedRecordId: pageDefinition.selectedRecordId,
    };
};
const ConnectedHeaderNavigationArrows = connect(mapStateToProps)(HeaderNavigationArrows);
export default ConnectedHeaderNavigationArrows;
//# sourceMappingURL=header-navigation-arrows.js.map