import * as React from 'react';
import { useSelector } from 'react-redux';
import { PrintRecordButton } from './print-record-button';
import { getPagePropertiesFromState, getPageDefinitionFromState } from '../../../utils/state-utils';
import { getScreenElement } from '../../../service/screen-base-definition';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { ConnectedHeaderQuickActions } from './header-quick-actions';
import { ConnectedHeaderDropdownActions } from './header-dropdown-actions';
import { isEmpty, isEqual } from 'lodash';
import { HeaderSectionToggleButton } from './header-section-toggle-button';
import { Page360Switch } from '../page-360/page-360-switch';
export function HeaderLineActionIconButtonGroup({ screenId, contextType, isSectionToggleDisplayed, is360SwitchDisplayed, }) {
    const { finalDropdownActions, finalQuickActions } = useSelector(state => {
        const pageProperties = getPagePropertiesFromState(screenId, state);
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        const headerField = pageProperties.headerField?.apply(getScreenElement(pageDefinition));
        const headerQuickActions = resolveByValue({
            skipHexFormat: true,
            screenId,
            propertyValue: pageProperties.headerQuickActions,
            rowValue: null,
            fieldValue: null,
            state,
        });
        const headerDropdownActions = resolveByValue({
            skipHexFormat: true,
            screenId,
            propertyValue: pageProperties.headerDropDownActions,
            rowValue: null,
            fieldValue: null,
            state,
        });
        const shouldMerge = state.browser.lessThan.l && !!headerField;
        const quickActions = headerQuickActions ?? [];
        const dropdownActions = headerDropdownActions ?? [];
        return shouldMerge
            ? {
                finalQuickActions: [],
                finalDropdownActions: [...quickActions, ...dropdownActions],
            }
            : {
                finalQuickActions: quickActions,
                finalDropdownActions: dropdownActions,
            };
    }, isEqual);
    if (isEmpty(finalDropdownActions) && isEmpty(finalQuickActions)) {
        return null;
    }
    return (React.createElement("span", { className: "e-header-line-icon-group" },
        React.createElement(PrintRecordButton, { screenId: screenId }),
        React.createElement(ConnectedHeaderQuickActions, { screenId: screenId, actions: finalQuickActions }),
        React.createElement(ConnectedHeaderDropdownActions, { contextType: contextType, screenId: screenId, actions: finalDropdownActions }),
        is360SwitchDisplayed && React.createElement(Page360Switch, { screenId: screenId }),
        isSectionToggleDisplayed && (React.createElement("div", { className: "e-header-line-icon-group-section-toggle" },
            React.createElement(HeaderSectionToggleButton, { screenId: screenId })))));
}
//# sourceMappingURL=header-line-action-icon-button-group.js.map