import * as tokens from '@sage/design-tokens/js/base/common';
import { noop } from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { getElementAccessStatus } from '../../../utils/access-utils';
import { triggerFieldEvent } from '../../../utils/events';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { getPageDefinitionFromState, getPagePropertiesFromState } from '../../../utils/state-utils';
import { PageActionControlObject } from '../../page-action/page-action-control-object';
import XtremActionPopover from '../../ui/xtrem-action-popover';
export function HeaderDropdownActions({ contextType, headerDropdownActions, }) {
    if (!headerDropdownActions) {
        return null;
    }
    return (React.createElement("span", { className: "e-header-dropdown-action-container" },
        React.createElement(XtremActionPopover, { items: headerDropdownActions, isOverSidebar: contextType === 'dialog', noIconSupport: false, color: tokens.colorsUtilityMajor450, pendoId: "headerDropdownActions" })));
}
export const ConnectedHeaderDropdownActions = connect((state, props) => {
    const pageProperties = getPagePropertiesFromState(props.screenId, state);
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const rawActions = props.actions ??
        resolveByValue({
            skipHexFormat: true,
            screenId: props.screenId,
            propertyValue: pageProperties.headerDropDownActions,
            rowValue: null,
            fieldValue: null,
        });
    if (!rawActions) {
        return props;
    }
    const resolvedPopoverItems = rawActions.map(e => {
        if (!(e instanceof PageActionControlObject) && e.isMenuSeparator) {
            // INFO: This is a menu separator injected via ui.menuSeparator()
            return {
                key: e.id,
                isMenuSeparator: true,
            };
        }
        const actionProperties = pageDefinition.metadata.uiComponentProperties[e.id];
        const accessRule = getElementAccessStatus({
            accessBindings: pageDefinition.accessBindings,
            bind: e.id,
            elementProperties: actionProperties,
            contextNode: pageProperties?.node,
            nodeTypes: state.nodeTypes,
            dataTypes: state.dataTypes,
        });
        const isDisabled = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.isDisabled,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        });
        const isHidden = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.isHidden,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        }) ||
            (actionProperties.access && accessRule !== 'authorized');
        const isMenuSeparator = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.isMenuSeparator,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        });
        const title = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.title,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        });
        return {
            icon: actionProperties.icon,
            isDestructive: actionProperties.isDestructive,
            isDisabled,
            isHidden,
            isMenuSeparator,
            key: e.id,
            onClick: e.isMenuSeparator
                ? noop
                : () => {
                    state.applicationContext?.onTelemetryEvent?.(`headerDropdownMenuItemTriggered-${e.id}`, {
                        screenId: props.screenId,
                        elementId: e.id,
                    });
                    return triggerFieldEvent(props.screenId, e.id, 'onClick');
                },
            pendoId: e.isMenuSeparator ? undefined : `${props.screenId}-headerDropdownAction-${e.id}`,
            title,
        };
    });
    return {
        ...props,
        headerDropdownActions: resolvedPopoverItems,
    };
})(HeaderDropdownActions);
//# sourceMappingURL=header-dropdown-actions.js.map