import * as React from 'react';
import { connect } from 'react-redux';
import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import * as tokens from '@sage/design-tokens/js/base/common';
import { localize } from '../../../service/i18n-service';
import * as xtremRedux from '../../../redux';
export function BackArrowButton({ history, onGoBack }) {
    const handleBack = () => {
        onGoBack?.();
    };
    if (history.length === 0)
        return null;
    return (React.createElement("div", { className: "e-header-navigation-return-arrow-parent-page-container", "data-testid": "e-header-navigation-arrow-return" },
        React.createElement(IconButton, { "aria-label": localize('@sage/xtrem-ui/return-arrow', 'Return'), "data-testid": "e-header-navigation-arrow-return", onClick: handleBack },
            React.createElement(Icon, { type: "arrow_left", color: tokens.colorsYin090, tooltipMessage: localize('@sage/xtrem-ui/return-arrow', 'Return') }))));
}
const mapStateToProps = (state, props) => ({
    ...props,
    history: state.navigation.history,
});
const mapDispatchToProps = (dispatch) => {
    return { onGoBack: () => dispatch(xtremRedux.actions.goBack()) };
};
const ConnectedBackArrowButton = connect(mapStateToProps, mapDispatchToProps)(BackArrowButton);
export default ConnectedBackArrowButton;
//# sourceMappingURL=header-back-arrow.js.map