import * as React from 'react';
import { ConnectedDashboardComponent } from '../../../dashboard/dashboard-component';
import { useSelector } from 'react-redux';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
export function Page360View({ screenId }) {
    const recordId = useSelector(state => getPageDefinitionFromState(screenId, state)?.selectedRecordId);
    if (!recordId) {
        return null;
    }
    return (React.createElement("div", { className: "e-page-360-view" },
        React.createElement(ConnectedDashboardComponent, { group: `${screenId}-360`, dashboardContextVariables: { recordId } })));
}
//# sourceMappingURL=page-360-view.js.map