import * as React from 'react';
import Switch from 'carbon-react/esm/components/switch';
import Icon from 'carbon-react/esm/components/icon';
import { localize } from '../../../service/i18n-service';
import { useDispatch, useSelector } from 'react-redux';
import { getPageDefinitionFromState, getPagePropertiesFromState, isScreenDefinitionDirty, } from '../../../utils/state-utils';
import * as xtremRedux from '../../../redux';
import { update360ViewInPath } from '../../../redux/actions';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { NEW_PAGE } from '../../../utils/constants';
export function Page360Switch({ screenId }) {
    const dispatch = useDispatch();
    const is360ViewOn = useSelector(state => !!getPageDefinitionFromState(screenId, state)?.is360ViewOn);
    const isDisabled = useSelector(state => isScreenDefinitionDirty(getPageDefinitionFromState(screenId, state)));
    const isNewPage = useSelector(state => {
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        return pageDefinition.queryParameters?._id === NEW_PAGE;
    });
    const has360View = useSelector(state => {
        const pageProperties = getPagePropertiesFromState(screenId, state);
        return (resolveByValue({
            skipHexFormat: true,
            screenId,
            propertyValue: pageProperties.has360View,
            rowValue: null,
            fieldValue: null,
            state,
        }) || false);
    });
    const onChange = React.useCallback((ev) => {
        const isEnabled = ev.target.checked;
        dispatch(xtremRedux.actions.set360ViewState(screenId, isEnabled, true));
        dispatch(update360ViewInPath(isEnabled));
    }, [dispatch, screenId]);
    if (isNewPage || !has360View) {
        return null;
    }
    return (React.createElement("div", { className: `e-page-360-switch ${is360ViewOn ? 'active' : ''} ${isDisabled ? 'disabled' : ''}`, "data-testid": "e-page-360-switch", "data-pendoid": "360ViewContainer" },
        React.createElement(Icon, { type: "dashboard", color: is360ViewOn ? 'var(--colorsActionMinor500)' : 'var(--colorsUtilityMajor300)', marginRight: "8px", disabled: isDisabled }),
        React.createElement("div", { className: "e-page-360-switch-input" },
            React.createElement(Switch, { "data-pendoid": `360View${is360ViewOn ? 'Enable' : 'Disable'}`, checked: is360ViewOn, disabled: isDisabled, label: localize('@sage/xtrem-ui/360-view', '360 view'), labelInline: true, onChange: onChange }))));
}
//# sourceMappingURL=page-360-switch.js.map