import ButtonMinor from 'carbon-react/esm/components/button-minor';
import * as React from 'react';
import { localize } from '../../../service/i18n-service';
import { DASHBOARD_SCREEN_ID } from '../../../utils/constants';
function ToggleNavigationPanelButton(props) {
    const toggle = () => {
        props.setNavigationPanelIsOpened(!props.isNavigationPanelOpened);
        if (props.parentOnClick && props.parentRef) {
            props.parentOnClick(props.parentRef);
        }
    };
    const iconType = props.isNavigationPanelOpened ? 'chevron_left' : 'chevron_right';
    const label = props.screenId === DASHBOARD_SCREEN_ID ?
        localize('@sage/xtrem-ui/toggle-widget-list', 'Toggle widget list') :
        localize('@sage/xtrem-ui/toggle-navigation-panel', 'Toggle Navigation Panel');
    const navPanelButtonClass = props.screenId === DASHBOARD_SCREEN_ID ?
        'e-navigation-panel-toggle e-dashboard-context' :
        'e-navigation-panel-toggle';
    return (React.createElement("div", { className: navPanelButtonClass },
        React.createElement(ButtonMinor, { ref: props.parentRef, iconType: iconType, onClick: toggle, buttonType: "tertiary", size: "large", iconTooltipPosition: "bottom", iconTooltipMessage: label, "aria-label": label, "data-testid": `nav-panel-toggle-button-${props.isNavigationPanelOpened ? 'close' : 'open'}`, "data-pendoid": "closeNavigationPanel" })));
}
export default ToggleNavigationPanelButton;
//# sourceMappingURL=toggle-navigation-panel-button.js.map