import * as React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { localize } from '../../../service/i18n-service';
import { getRouter } from '../../../service/router';
import { NEW_PAGE, DASHBOARD_SCREEN_ID } from '../../../utils/constants';
import { getPageDefinitionFromState, getPagePropertiesFromState } from '../../../utils/state-utils';
import { getFieldTitle } from '../../field/carbon-helpers';
import { PageTitle } from '../../ui/page-title';
import { TableCreateActions } from '../../ui/table-shared/table-create-actions/table-create-actions';
import { BusinessAction } from '../footer/business-action';
import { ConnectedNavigationPanelBodyItems } from './navigation-panel-body-items';
import { navigationPanelId } from './navigation-panel-types';
import BackArrowButton from '../page/header-back-arrow';
import { PageHeaderInsightsButton } from '../../ui/insights-button';
import { ContextType } from '../../../types';
export class NavigationPanel extends React.Component {
    constructor() {
        super(...arguments);
        this.togglePanelButtonRef = React.createRef();
        this.isFullWidth = () => !this.props.isRecordSelected &&
            !this.props.isNewPage &&
            !this.props.isNavigationPanelHidden &&
            !this.props.browser?.is.xs;
        this.setChevronFocus = () => {
            if (this.togglePanelButtonRef.current) {
                this.togglePanelButtonRef.current.focus();
            }
        };
        this.setNavigationPanelIsOpened = (newState) => {
            if (!newState && this.props.browser?.is.xs && !this.props.isRecordSelected) {
                getRouter(this.props.screenId).emptyPage();
            }
            else {
                this.props.setNavigationPanelIsOpened(newState);
            }
        };
        this.renderSplitHeaderActions = () => {
            const toggleLabel = this.props.screenId === DASHBOARD_SCREEN_ID
                ? localize('@sage/xtrem-ui/toggle-widget-list', 'Toggle widget list')
                : localize('@sage/xtrem-ui/toggle-navigation-panel', 'Toggle Navigation Panel');
            return (React.createElement("div", { className: "e-page-navigation-panel-header-actions" },
                this.props.createAction && (React.createElement("span", { className: "e-create-actions", "data-testid": "e-create-actions" },
                    React.createElement(TableCreateActions, { createActions: this.props.createAction, multiActionType: "split-button", screenId: this.props.screenId, elementId: navigationPanelId }))),
                !this.props.browser?.greaterThan.l && !this.isFullWidth() && (React.createElement(BusinessAction, { parentRef: this.togglePanelButtonRef, onClick: () => this.setNavigationPanelIsOpened(false), id: "$toggleNavigationPanel", icon: "chevron_left", screenId: this.props.screenId, isIconOnly: true, title: toggleLabel, buttonType: "tertiary", size: "small", pendoId: "closeNavigationPanel" }))));
        };
        this.renderTitle = () => {
            return (React.createElement("div", { className: "e-page-navigation-panel-header-title-container" },
                this.props.shouldDisplayBackArrow && this.props.browser?.is.xs && (React.createElement(BackArrowButton, { screenId: this.props.screenId })),
                React.createElement("div", { className: "e-page-navigation-panel-header-title" }, this.props.title),
                this.renderSplitHeaderActions()));
        };
        this.renderHeaderTop = () => (React.createElement("div", { "data-testid": "e-page-navigation-panel-full-width-header-top", className: "e-page-navigation-panel-header-top" }, !this.isFullWidth() && this.renderTitle()));
        this.isHeaderHidden = () => {
            return (this.props.navigationPanelDefinition.isHeaderHidden ||
                this.props.selectedRecordIds.length > 0 ||
                this.props.isSelectAllChecked);
        };
        this.renderFullWidth = () => {
            return (React.createElement("main", { className: "e-page-navigation-panel e-page-navigation-panel-full-width", "data-testid": "e-page-navigation-panel-full-width" },
                this.props.contextType !== ContextType.dialog && (React.createElement(React.Fragment, null,
                    React.createElement("div", { className: "e-page-navigation-panel-title" },
                        this.props.shouldDisplayBackArrow && React.createElement(BackArrowButton, { screenId: this.props.screenId }),
                        React.createElement(PageTitle, { title: this.props.title }),
                        React.createElement(PageHeaderInsightsButton, { screenId: this.props.screenId })),
                    React.createElement("div", { className: "e-page-navigation-panel-guide" }))),
                React.createElement("div", { className: "e-page-navigation-panel-body" },
                    React.createElement(ConnectedNavigationPanelBodyItems, { screenId: this.props.screenId, isFullWidthGrid: this.isFullWidth() }))));
        };
    }
    componentDidMount() {
        /*
        TODO: might be better dispatch this action (or similar)
        in an earlier phase (maybe at each xtrem page init, mount...)
        and let the navigation panel consume that value
        instead of accessing mutable navigationPanelDefinition prop
        */
        this.props.setNavigationPanelIsHeaderHidden(!!this.props.navigationPanelDefinition.isHeaderHidden);
    }
    componentDidUpdate(prevProps) {
        if (this.props.isNavigationPanelOpened !== prevProps.isNavigationPanelOpened) {
            this.setChevronFocus();
        }
    }
    render() {
        const navPanelClassNames = this.props.isNavigationPanelHidden ? 'e-hidden' : 'e-page-navigation-panel';
        return this.isFullWidth() ? (this.renderFullWidth()) : (React.createElement("nav", { "data-testid": "e-page-navigation-panel-split-view", className: navPanelClassNames },
            React.createElement("div", { className: "e-page-navigation-panel-header" }, !this.isHeaderHidden() && this.renderHeaderTop()),
            React.createElement("div", { className: "e-page-navigation-panel-body" },
                React.createElement(ConnectedNavigationPanelBodyItems, { screenId: this.props.screenId, isFullWidthGrid: this.isFullWidth() }))));
    }
}
const mapStateToProps = (state, props) => {
    const pageProperties = getPagePropertiesFromState(props.screenId, state);
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const navigationPanelDefinition = pageProperties.navigationPanel;
    const navigationPanel = state.screenDefinitions[props.screenId].navigationPanel;
    if (!navigationPanel || !navigationPanelDefinition) {
        throw new Error(`No navigationPanel definition found for ${props.screenId}`);
    }
    const isRecordSelected = Boolean(props.selectedRecordId);
    const isNewPage = Boolean(state.screenDefinitions[props.screenId].queryParameters?._id === NEW_PAGE);
    const history = state.navigation.history;
    return {
        ...props,
        browser: state.browser,
        createAction: pageProperties.createAction,
        isNavigationPanelHidden: navigationPanel.isHidden,
        isNavigationPanelOpened: navigationPanel.isOpened,
        isNewPage,
        isRecordSelected,
        isSelectAllChecked: pageDefinition.metadata.uiComponentProperties.$navigationPanel
            ?.isSelectAllChecked ?? false,
        navigationPanelDefinition,
        selectedRecordIds: pageDefinition.metadata.uiComponentProperties.$navigationPanel
            ?.selectedRecords ?? [],
        setNavigationPanelIsHeaderHidden: xtremRedux.actions.actionStub,
        setNavigationPanelIsOpened: xtremRedux.actions.actionStub,
        title: pageProperties.objectTypePlural || getFieldTitle(props.screenId, pageProperties, null) || '',
        shouldDisplayBackArrow: history.length > 0,
    };
};
const mapDispatchToProps = (dispatch, props) => {
    return {
        setNavigationPanelIsHeaderHidden: (isHeaderHidden) => dispatch(xtremRedux.actions.setNavigationPanelIsHeaderHidden(isHeaderHidden, props.screenId)),
        setNavigationPanelIsOpened: (isOpened) => dispatch(xtremRedux.actions.setNavigationPanelIsOpened(isOpened, props.screenId)),
    };
};
export default connect(mapStateToProps, mapDispatchToProps)(NavigationPanel);
//# sourceMappingURL=navigation-panel-component.js.map