import * as React from 'react';
import type { ReduxResponsive } from '../../../redux/state';
import type { Page } from '../../../service/page';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValueOrCallback } from '../../../utils/types';
import type { PageActionControlObject } from '../../page-action/page-action-control-object';
import type { PageNavigationPanel } from '../page/page-types';
import { ContextType } from '../../../types';
export interface NavigationPanelExternalProps {
    screenId: string;
    selectedRecordId: string | null;
    contextType: ContextType;
}
export interface NavigationPanelProps extends Omit<NavigationPanelExternalProps, 'selectedRecordId'> {
    browser?: ReduxResponsive;
    createAction?: ValueOrCallback<ScreenBase, PageActionControlObject | PageActionControlObject[]>;
    isNavigationPanelHidden: boolean;
    isNavigationPanelOpened: boolean;
    isNewPage: boolean;
    isRecordSelected: boolean;
    isSelectAllChecked: boolean;
    navigationPanelDefinition: PageNavigationPanel<Page>;
    selectedRecordIds: string[];
    setNavigationPanelIsHeaderHidden: (isHeaderHidden: boolean) => void;
    setNavigationPanelIsOpened: (isOpened: boolean) => void;
    title: string;
    shouldDisplayBackArrow: boolean;
}
export declare class NavigationPanel extends React.Component<NavigationPanelProps> {
    private togglePanelButtonRef;
    componentDidMount(): void;
    componentDidUpdate(prevProps: NavigationPanelProps): void;
    private readonly isFullWidth;
    setChevronFocus: () => void;
    private readonly setNavigationPanelIsOpened;
    private readonly renderSplitHeaderActions;
    private readonly renderTitle;
    private readonly renderHeaderTop;
    private readonly isHeaderHidden;
    renderFullWidth: () => React.ReactNode;
    render(): React.ReactNode;
}
declare const _default: import("react-redux").ConnectedComponent<typeof NavigationPanel, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<NavigationPanel> | undefined;
    screenId: string;
    selectedRecordId: string | null;
    contextType: ContextType;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=navigation-panel-component.d.ts.map