import * as React from 'react';
import { AsyncTableComponent } from '../../field/table/async-table-component';
import { navigationPanelId } from './navigation-panel-types';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { getNavigationPanelTablePropertiesFromPageDefinition, getPageDefinitionFromState, getPagePropertiesFromPageDefinition, } from '../../../utils/state-utils';
import { ContextType } from '../../../types';
import { DASHBOARD_SCREEN_ID } from '../../../utils/constants';
function NavigationPanelBodyItems({ accessBindings, browser, bulkActions, dataTypes, enumTypes, groupByField, isAutoSelectEnabled, isFullWidthGrid, isSoundDisabled, locale, nodeTypes, screenId, selectedRecordId, setFieldProperties, tableProperties, tableUserSettings, username, value, }) {
    if (!tableProperties || !value || !locale) {
        return null;
    }
    const selectedRecords = selectedRecordId ? [selectedRecordId] : undefined;
    // The dropdown actions should be hidden on the split navigation panel, when not accessed on small screen
    const shouldShowCardActions = browser.is.xs || isFullWidthGrid;
    const dropdownActions = shouldShowCardActions ? tableProperties.dropdownActions : undefined;
    const inlineActions = shouldShowCardActions ? tableProperties.inlineActions : undefined;
    return (React.createElement("div", { style: { flex: 1, width: '100%' } },
        React.createElement(AsyncTableComponent, { accessBindings: accessBindings, browser: browser, contextType: ContextType.navigationPanel, dataTypes: dataTypes, elementId: navigationPanelId, enumTypes: enumTypes, canDragCard: screenId === DASHBOARD_SCREEN_ID, fieldProperties: {
                ...tableProperties,
                isSoundDisabled,
                cardView: !isFullWidthGrid,
                selectedRecords,
                canSelect: tableProperties.canSelect && isFullWidthGrid && (bulkActions ?? []).length > 0,
                dropdownActions,
                inlineActions,
                isTitleHidden: true,
            }, groupByField: groupByField, isAutoSelectEnabled: isAutoSelectEnabled, isUsingInfiniteScroll: true, bulkActions: bulkActions, locale: locale, selectionMode: (bulkActions ?? []).length > 0 ? 'multiple' : undefined, nodeTypes: nodeTypes, screenId: screenId, setFieldProperties: setFieldProperties, skeletonHeight: "calc(100dvh - 150px)", tableUserSettings: tableUserSettings, username: username, validationErrors: [], value: value })));
}
const mapStateToProps = (state, props) => {
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    if (!pageDefinition || !pageDefinition.navigationPanel) {
        throw new Error(`No page or page navigation panel found for ${props.screenId}.`);
    }
    const pageProperties = getPagePropertiesFromPageDefinition(pageDefinition);
    const navigationPanel = state.screenDefinitions[props.screenId].navigationPanel;
    return {
        ...props,
        accessBindings: pageDefinition.accessBindings,
        browser: state.browser,
        bulkActions: pageProperties?.navigationPanel?.bulkActions,
        dataTypes: state.dataTypes,
        enumTypes: state.enumTypes,
        groupByField: navigationPanel?.groupByField,
        isAutoSelectEnabled: pageProperties?.navigationPanel?.isAutoSelectEnabled || false,
        isSoundDisabled: pageProperties?.navigationPanel?.isSoundDisabled,
        locale: state.applicationContext?.locale,
        nodeTypes: state.nodeTypes,
        selectedRecordId: pageDefinition.selectedRecordId,
        tableProperties: getNavigationPanelTablePropertiesFromPageDefinition(pageDefinition),
        tableUserSettings: state.screenDefinitions[props.screenId]?.userSettings?.[navigationPanelId] || {},
        username: state.applicationContext?.login,
        value: pageDefinition.navigationPanel.value,
    };
};
const mapDispatchToProps = (dispatch, props) => {
    return {
        setFieldProperties: (elementId, value) => {
            dispatch(xtremRedux.actions.setFieldProperties(props.screenId, elementId, value));
        },
    };
};
export const ConnectedNavigationPanelBodyItems = connect(mapStateToProps, mapDispatchToProps)(NavigationPanelBodyItems);
//# sourceMappingURL=navigation-panel-body-items.js.map