import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import * as React from 'react';
import type { ReduxResponsive } from '../../../redux/state';
import type { CollectionValue } from '../../../service/collection-data-service';
import type { TableDecoratorProperties } from '../../decorators';
import type { ValueOrCallback } from '../../../utils/types';
import type { BulkAction } from '../../control-objects';
import type { InternalTableProperties, TableUserSettings } from '../../field/table/table-component-types';
import type { PropertyValueType } from '../../field/reference/reference-types';
import type { DataTypeDetails, FormattedNodeDetails } from '../../../service/metadata-types';
import type { AccessBindings } from '../../../service/page-definition';
export interface NavigationPanelBodyItemsExternalProps {
    isFullWidthGrid?: boolean;
    screenId: string;
    setFieldProperties?: (elementId: string, properties: InternalTableProperties) => void;
}
export interface NavigationPanelBodyItemsProps extends NavigationPanelBodyItemsExternalProps {
    accessBindings: AccessBindings;
    browser: ReduxResponsive;
    bulkActions?: BulkAction[];
    dataTypes: Dict<DataTypeDetails>;
    enumTypes: Dict<string[]>;
    groupByField?: PropertyValueType;
    isAutoSelectEnabled: boolean;
    isSoundDisabled?: ValueOrCallback<any, boolean>;
    locale?: LocalizeLocale;
    nodeTypes: Dict<FormattedNodeDetails>;
    selectedRecordId?: string | null;
    tableProperties?: TableDecoratorProperties;
    tableUserSettings: Dict<TableUserSettings>;
    username?: string;
    value?: CollectionValue;
}
declare function NavigationPanelBodyItems({ accessBindings, browser, bulkActions, dataTypes, enumTypes, groupByField, isAutoSelectEnabled, isFullWidthGrid, isSoundDisabled, locale, nodeTypes, screenId, selectedRecordId, setFieldProperties, tableProperties, tableUserSettings, username, value, }: NavigationPanelBodyItemsProps): React.ReactElement | null;
export declare const ConnectedNavigationPanelBodyItems: import("react-redux").ConnectedComponent<typeof NavigationPanelBodyItems, {
    isFullWidthGrid?: boolean | undefined;
    screenId: string;
    setFieldProperties?: ((elementId: string, properties: InternalTableProperties) => void) | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export {};
//# sourceMappingURL=navigation-panel-body-items.d.ts.map