/**
 * @packageDocumentation
 * @module root
 * */
import { getPageMetadata } from '../../../service/page-metadata';
import { getTargetPrototype, standardExtensionDecoratorImplementation } from '../../../utils/decorator-utils';
import { AbstractDecorator } from '../../abstract-decorator';
import { ContainerKey } from '../../types';
import { GridRowBlockControlObject } from './grid-row-block-control-object';
import { GridRowBlockLayout } from './grid-row-block-layout';
class GridRowBlockDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._layout = GridRowBlockLayout;
        this._controlObjectConstructor = GridRowBlockControlObject;
    }
}
/**
 * Initializes the decorated member as a [Block]{@link GridRowBlockControlObject} container with the provided properties
 *
 * @param properties The properties that the [Block]{@link GridRowBlockControlObject} container will be initialized with
 */
export function gridRowBlock(properties) {
    return function gridRowBlockDecorator(target, name) {
        const pageMetadata = getPageMetadata(getTargetPrototype(target.constructor), target);
        pageMetadata.blockThunks[name] = (nodeTypes, dataTypes) => new GridRowBlockDecorator(pageMetadata.target, name, { pageMetadata, properties }, ContainerKey.GridRowBlock, nodeTypes, dataTypes, {}).build().layout;
    };
}
export function gridRowBlockOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=grid-row-block-decorator.js.map