import * as React from 'react';
import type { ReduxResponsive } from '../../../redux/state';
import type { PageArticleItem } from '../../../service/layout-types';
import type { ContextType } from '../../../types';
import type { NestedGridProperties } from '../../field/field-control-objects';
import type { InternalTableProperties } from '../../field/table/table-component-types';
import type { GridRowBlockDecoratorProperties } from './grid-row-block-types';
export interface GridRowBlockComponentExternalProps {
    item: Partial<PageArticleItem>;
    screenId: string;
    contextType?: ContextType;
    availableColumns: number;
    isParentDisabled?: boolean;
    /**
     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
     * down the hidden status and mark the hidden inputs not focusable
     * */
    isParentHidden?: boolean;
}
export interface GridRowBlockComponentProps extends GridRowBlockComponentExternalProps {
    screenType: string;
    fieldProperties: GridRowBlockDecoratorProperties;
    browser?: ReduxResponsive;
    referredTableProperties?: InternalTableProperties | NestedGridProperties;
    parentElementId: string;
}
export declare function GridRowBlockComponent(props: GridRowBlockComponentProps): React.ReactElement | null;
export declare const ConnectedGridRowBlockComponent: import("react-redux").ConnectedComponent<typeof GridRowBlockComponent, {
    item: Partial<PageArticleItem>;
    screenId: string;
    contextType?: ContextType | undefined;
    availableColumns: number;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedGridRowBlockComponent;
//# sourceMappingURL=grid-row-block-component.d.ts.map