import { getPageMetadata } from '../../../service/page-metadata';
import { getTargetPrototype } from '../../../utils/decorator-utils';
import { AbstractDecorator } from '../../abstract-decorator';
import { FragmentFieldsControlObject } from './fragment-fields-control-object';
import { ContainerKey } from '../../types';
class FragmentFieldsDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = FragmentFieldsControlObject;
    }
}
export function fragmentFields(properties) {
    return function fragmentFieldsDecorator(target, name) {
        const pageMetadata = getPageMetadata(getTargetPrototype(target.constructor), target);
        pageMetadata.definitionOrder.push(name);
        pageMetadata.fragmentFieldsThunks[name] = () => {
            return new FragmentFieldsDecorator(pageMetadata.target, name, { pageMetadata, properties }, ContainerKey.FragmentFields, {}, {}, {}).build().controlObject;
        };
    };
}
//# sourceMappingURL=fragment-fields-decorator.js.map