import Button from 'carbon-react/esm/components/button';
import Loader from 'carbon-react/esm/components/loader';
import * as React from 'react';
import { connect } from 'react-redux';
import { triggerFieldEvent } from '../../../utils/events';
import { getFieldTitle, isFieldDisabled, isFieldHidden } from '../../field/carbon-helpers';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { BusinessActionButtonWrapper } from './bussiness-action-button-wrapper';
import { getDataTestIdAttribute } from '../../../utils/dom';
import Tooltip from 'carbon-react/esm/components/tooltip';
import { localize } from '../../../service/i18n-service';
export class BusinessAction extends React.Component {
    constructor() {
        super(...arguments);
        this.onClick = () => {
            if (this.props.onClick) {
                this.props.onClick();
                if (!this.props.alwaysTriggerFieldEvent) {
                    // The multi action button registers an onClick prop even if we don't want it.
                    return;
                }
            }
            if (this.props.id) {
                triggerFieldEvent(this.props.screenId, this.props.id, 'onClick');
                this.props.onTelemetryEvent?.(`businessActionTriggered-${this.props.id}`, {
                    elementId: this.props.id,
                    screen: this.props.screenId,
                });
            }
        };
    }
    render() {
        if (this.props.isHidden) {
            return null;
        }
        const isIconOnly = this.props.isIconOnly && this.props.icon;
        const testId = this.props['data-testid']
            ? this.props['data-testid']
            : this.props.skipWrapping
                ? getDataTestIdAttribute('business-action', this.props.title, this.props.id)
                : undefined;
        let button = (React.createElement(Button, { className: this.props.className, paddingLeft: this.props.isLoading ? '8px' : '24px', ref: this.props.parentRef, buttonType: this.props.buttonType || this.props.defaultButtonType, disabled: this.props.isDisabled || this.props.isLoading, destructive: this.props.isDestructive, iconType: this.props.icon, mr: this.props.isSeparated ? '8px' : undefined, onClick: this.onClick, size: this.props.size || 'medium', iconTooltipMessage: isIconOnly ? this.props.title : undefined, "aria-label": isIconOnly ? this.props.title : undefined, "data-testid": testId, "data-pendoid": this.props.pendoId && this.props.id ? `${this.props.pendoId}-${this.props.id}` : undefined },
            this.props.isLoading && React.createElement(Loader, { size: "small", marginRight: "8px" }),
            isIconOnly ? undefined : this.props.title));
        if (this.props.isLoading || this.props.helperText) {
            const tooltipMessage = this.props.isLoading
                ? localize('@sage/xtrem-ui/business-action-in-progress', 'This process is running in the background.')
                : this.props.helperText;
            button = React.createElement(Tooltip, { message: tooltipMessage }, button);
        }
        if (this.props.skipWrapping) {
            return button;
        }
        return (React.createElement(BusinessActionButtonWrapper, { id: this.props.id, title: this.props.title }, button));
    }
}
const mapStateToProps = (state, props) => {
    if (!props.id) {
        throw new Error('Action id must be supplied when the business action used in connected mode');
    }
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const actionProperties = pageDefinition.metadata.uiComponentProperties[props.id];
    return {
        ...props,
        buttonType: props.buttonTypeOverride || actionProperties.buttonType,
        helperText: actionProperties.helperText,
        icon: actionProperties.icon,
        isDestructive: actionProperties.isDestructive,
        isLoading: actionProperties.isLoading,
        isHidden: isFieldHidden(props.screenId, actionProperties, null),
        isDisabled: !!props.disabled || isFieldDisabled(props.screenId, actionProperties, null, null),
        title: props.title || getFieldTitle(props.screenId, actionProperties, null),
        onTelemetryEvent: state.applicationContext?.onTelemetryEvent,
    };
};
export const ConnectedBusinessAction = connect(mapStateToProps)(BusinessAction);
ConnectedBusinessAction.displayName = 'Button';
export default ConnectedBusinessAction;
//# sourceMappingURL=business-action.js.map