import * as React from 'react';
import type { PageActionButtonType } from '../../control-objects';
import type { IconType } from 'carbon-react/esm/components/icon';
import type { OnTelemetryEventFunction } from '../../../redux/state';
export interface BusinessActionExternalProps {
    alwaysTriggerFieldEvent?: boolean;
    buttonTypeOverride?: PageActionButtonType;
    className?: string;
    'data-testid'?: string;
    defaultButtonType?: PageActionButtonType;
    disabled?: boolean;
    id?: string;
    isIconOnly?: boolean;
    isSeparated?: boolean;
    onClick?: () => void;
    parentRef?: React.Ref<HTMLButtonElement>;
    pendoId?: string;
    screenId: string;
    size?: 'small' | 'medium';
    skipWrapping?: boolean;
    title?: string;
}
export interface BusinessActionProps extends BusinessActionExternalProps {
    buttonType?: PageActionButtonType;
    helperText?: string;
    icon?: IconType;
    isDestructive?: boolean;
    isDisabled?: boolean;
    isHidden?: boolean;
    isLoading?: boolean;
    onTelemetryEvent?: OnTelemetryEventFunction;
    title?: string;
}
export declare class BusinessAction extends React.Component<BusinessActionProps> {
    onClick: () => void;
    render(): React.ReactNode;
}
export declare const ConnectedBusinessAction: import("react-redux").ConnectedComponent<typeof BusinessAction, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<BusinessAction> | undefined;
    alwaysTriggerFieldEvent?: boolean | undefined;
    buttonTypeOverride?: import("carbon-react/esm/components/button/button.component").ButtonTypes | undefined;
    className?: string | undefined;
    'data-testid'?: string | undefined;
    defaultButtonType?: import("carbon-react/esm/components/button/button.component").ButtonTypes | undefined;
    disabled?: boolean | undefined;
    id?: string | undefined;
    isIconOnly?: boolean | undefined;
    isSeparated?: boolean | undefined;
    onClick?: (() => void) | undefined;
    parentRef?: React.Ref<HTMLButtonElement> | undefined;
    pendoId?: string | undefined;
    screenId: string;
    size?: "small" | "medium" | undefined;
    skipWrapping?: boolean | undefined;
    title?: string | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedBusinessAction;
//# sourceMappingURL=business-action.d.ts.map