import * as React from 'react';
import NavigationArrows from '../../../ui/navigation-arrows/navigation-arrows';
import Typography from 'carbon-react/esm/components/typography';
import Icon from 'carbon-react/esm/components/icon';
import { camelCase } from 'lodash';
import XtremActionPopover from '../../../ui/xtrem-action-popover';
import * as tokens from '@sage/design-tokens/js/base/common';
import IconButton from 'carbon-react/esm/components/icon-button';
import { useDispatch } from 'react-redux';
import * as xtremRedux from '../../../../redux';
import { calculateActionMenu, calculateActionMenuWithSeparator } from '../../../../utils/action-menu-utils';
import { triggerHandledEvent } from '../../../../utils/events';
import { cleanMetadataFromRecord, splitValueToMergedValue } from '../../../../utils/transformers';
import { useCollectionItemRecord } from '../../../connected-collection';
import { useDeepEqualSelector } from '../../../../utils/hooks/use-deep-equal-selector';
export function TableSidebarDialogTitle({ dialog }) {
    const content = dialog.content;
    const dialogId = dialog.dialogId;
    const screenId = dialog.screenId;
    const isLoading = !content.recordId;
    if (!screenId) {
        throw new Error('Screen ID is missing from dialog description.');
    }
    const dispatch = useDispatch();
    const accessBindings = useDeepEqualSelector((s) => s.screenDefinitions[screenId].accessBindings);
    const onTelemetryEvent = useDeepEqualSelector((s) => s.applicationContext?.onTelemetryEvent);
    const onNextRecord = React.useCallback(() => {
        return dispatch(xtremRedux.actions.selectSidebarNextRecord(dialogId));
    }, [dialogId, dispatch]);
    const onPrevRecord = React.useCallback(() => {
        return dispatch(xtremRedux.actions.selectSidebarPreviousRecord(dialogId));
    }, [dialogId, dispatch]);
    const recordValue = useCollectionItemRecord({
        elementId: content.elementId,
        screenId,
        isUncommitted: true,
        recordId: content.recordId || '',
    });
    const rowValue = splitValueToMergedValue(recordValue);
    const resolvedPopoverItems = React.useMemo(() => calculateActionMenuWithSeparator({
        accessBindings,
        actions: content.sidebarDefinition.headerDropdownActions,
        actionType: 'table-sidebar-header-dropdown-action',
        onTriggerMenuItem: (context, onClick, onActionError) => {
            onTelemetryEvent?.(`tableSidebarHeaderDropdownActionTriggered-${context.uniqueId}`, {
                screenId,
                elementId: content.elementId,
                id: context.id,
                uniqueId: context.uniqueId,
            });
            triggerHandledEvent(screenId, content.elementId, { onClick, onError: onActionError }, recordValue?._id || content.recordId, cleanMetadataFromRecord(splitValueToMergedValue(recordValue)));
        },
        rowValue,
        screenId,
    }), [
        accessBindings,
        content.recordId,
        content.elementId,
        content.sidebarDefinition.headerDropdownActions,
        onTelemetryEvent,
        recordValue,
        rowValue,
        screenId,
    ]);
    const resolvedHeaderQuickActions = React.useMemo(() => calculateActionMenu({
        accessBindings,
        actions: content.sidebarDefinition.headerQuickActions,
        actionType: 'table-sidebar-header-quick-action',
        onTriggerMenuItem: (context, onClick, onActionError) => {
            if (onTelemetryEvent) {
                onTelemetryEvent(`tableSidebarHeaderQuickActionTriggered-${context.uniqueId}`, {
                    screenId,
                    elementId: content.elementId,
                    id: context.id,
                    uniqueId: context.uniqueId,
                });
            }
            triggerHandledEvent(screenId, content.elementId, { onClick, onError: onActionError }, recordValue?._id || content.recordId, cleanMetadataFromRecord(splitValueToMergedValue(recordValue)));
        },
        rowValue,
        screenId,
    }), [
        accessBindings,
        content.elementId,
        content.recordId,
        content.sidebarDefinition.headerQuickActions,
        onTelemetryEvent,
        recordValue,
        rowValue,
        screenId,
    ]);
    return (React.createElement(Typography, { variant: "h3", mb: "16px", className: "e-sidebar-header", "data-testid": "e-sidebar-header" },
        React.createElement(NavigationArrows, { hasNextRecord: !!content.nextRecordId, hasPreviousRecord: !!content.prevRecordId, onNextRecord: onNextRecord, onPreviousRecord: onPrevRecord }),
        React.createElement("div", { className: "e-sidebar-title" }, dialog.title),
        !isLoading && resolvedHeaderQuickActions?.length > 0 && (React.createElement("div", { className: "e-sidebar-quick-action-container", "data-testid": "e-sidebar-quick-action-container" }, resolvedHeaderQuickActions.map(a => {
            if (!a.icon) {
                throw new Error('Icon is missing from sidebar quick action definition.');
            }
            if (a.isHidden) {
                return null;
            }
            return (React.createElement(IconButton, { key: a.icon, onClick: () => a.onClick(), disabled: a.isDisabled, "aria-label": a.title, ml: "16px", "data-testid": `e-sidebar-quick-action-label-${camelCase(a.title)}` },
                React.createElement(Icon, { type: a.icon, tooltipMessage: a.title, color: a.isDestructive
                        ? tokens.colorsSemanticNegative500
                        : tokens.colorsUtilityMajor400 })));
        }))),
        !isLoading && resolvedPopoverItems?.length > 0 && (React.createElement("div", { className: "e-sidebar-dropdown-action-container", "data-testid": "e-sidebar-dropdown-action-container" },
            React.createElement(XtremActionPopover, { items: resolvedPopoverItems, noIconSupport: false, color: tokens.colorsUtilityMajor450, isOverSidebar: true })))));
}
//# sourceMappingURL=table-sidebar-dialog-title.js.map