import { PageControlObject, SectionControlObject } from '../container-control-objects';
import { getVisibleSectionsFromPage } from '../../../utils/state-utils';
export const collectSections = (dialog, screenDefinitions) => {
    const content = dialog.content;
    if (content instanceof PageControlObject && dialog.screenId && screenDefinitions[dialog.screenId]) {
        const pageDefinition = screenDefinitions[dialog.screenId];
        const sections = getVisibleSectionsFromPage(dialog.screenId, pageDefinition);
        const detailPanel = pageDefinition.page.$.detailPanel;
        const detailPanelSectionIds = detailPanel
            ? [
                ...detailPanel.layout.detailPanelSectionsLayout.map(section => section.$containerId),
                detailPanel.layout.detailPanelHeaderLayout?.$containerId,
            ]
            : [];
        return sections.filter(section => detailPanelSectionIds.indexOf(section.id) === -1);
    }
    const allContent = content instanceof Array ? content : [content];
    return allContent.filter(ele => (ele instanceof SectionControlObject && !ele.isHidden) || !(ele instanceof SectionControlObject));
};
//# sourceMappingURL=dialog-utils.js.map