import * as React from 'react';
import { PageDialogTitle } from './page-dialog-title';
import { TableSidebarDialogTitle } from './table-sidebar/table-sidebar-dialog-title';
import Typography from 'carbon-react/esm/components/typography';
export function DialogTitle({ dialog, onCloseDialog, }) {
    if (dialog.type === 'page') {
        return React.createElement(PageDialogTitle, { dialog: dialog, onCloseDialog: onCloseDialog, baseTopMargin: "0px" });
    }
    if (dialog.type === 'table-sidebar') {
        return React.createElement(TableSidebarDialogTitle, { dialog: dialog });
    }
    const lineHeight = dialog.options.fullScreen ? '72px' : undefined;
    return (React.createElement("div", { "data-component": "heading" },
        React.createElement("div", { className: "e-header-container", "data-element": "header-container" },
            React.createElement(Typography, { "data-element": "title", variant: "h1", mt: "0px", mb: "0px", lineHeight: lineHeight }, dialog.title || ''))));
}
//# sourceMappingURL=dialog-title.js.map