import * as React from 'react';
import { getPageBodyColumnCount } from '../../../utils/responsive-utils';
import * as xtremRedux from '../../../redux';
import { useDispatch } from 'react-redux';
import { collectSections } from './dialog-utils';
import { DialogBodyContent } from './body/dialog-body-content';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
export function DialogContent({ dialog, activeSection, defaultFocusRef, noHeader, }) {
    const ref = React.useRef(null);
    const browser = useDeepEqualSelector(s => s.browser);
    const screenDefinitions = useDeepEqualSelector(s => s.screenDefinitions);
    const dispatch = useDispatch();
    const screenDefinition = dialog.screenId ? screenDefinitions[dialog.screenId] : undefined;
    const sections = collectSections(dialog, screenDefinitions);
    const currentSectionIndex = sections.findIndex(s => s?.id === activeSection);
    const gridColumnCount = React.useMemo(() => {
        if (browser.is.xs) {
            return 4;
        }
        if (dialog.options.fullScreen) {
            return getPageBodyColumnCount(browser?.is);
        }
        if (dialog.options.size === 'extra-large') {
            return 8;
        }
        return 4;
    }, [browser.is, dialog.options.fullScreen, dialog.options.size]);
    const onStepOneSection = React.useCallback((direction) => {
        if (dialog.content && dialog.type === 'page' && dialog.screenId) {
            dispatch(xtremRedux.actions.stepOneSection(dialog.screenId, direction));
        }
    }, [dialog.content, dialog.screenId, dialog.type, dispatch]);
    const dialogContentClasses = ['e-dialog-content', `e-dialog-type-${dialog.type || 'unknown'}`];
    const isFirstSection = !activeSection || currentSectionIndex === 0;
    const isLastSection = sections.length === currentSectionIndex + 1;
    return (React.createElement("div", { className: dialogContentClasses.join(' '), ref: ref },
        React.createElement("div", { className: "e-dialog-body", "data-testid": "e-dialog-body" },
            React.createElement(DialogBodyContent, { dialog: dialog, screenDefinition: screenDefinition, availableColumns: gridColumnCount, defaultFocusRef: defaultFocusRef, selectedSection: activeSection, noHeader: noHeader, onStepOneSection: onStepOneSection, isFirstSection: isFirstSection, isLastSection: isLastSection }))));
}
//# sourceMappingURL=dialog-content.js.map